"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDynamoDBTableWithStream = exports.buildDynamoDBTable = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const dynamodb_table_defaults_1 = require("./dynamodb-table-defaults");
const utils_1 = require("./utils");
function buildDynamoDBTable(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableObj) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableProps, props.dynamoTableProps);
            return new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
        }
        else {
            return new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableProps);
        }
    }
    else {
        return props.existingTableObj;
    }
}
exports.buildDynamoDBTable = buildDynamoDBTable;
function buildDynamoDBTableWithStream(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableObj) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableWithStreamProps, props.dynamoTableProps);
            return new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
        }
        else {
            return new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableWithStreamProps);
        }
    }
    else {
        return props.existingTableObj;
    }
}
exports.buildDynamoDBTableWithStream = buildDynamoDBTableWithStream;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1vZGItdGFibGUtaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZHluYW1vZGItdGFibGUtaGVscGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUgsa0RBQWtEO0FBRWxELHVFQUEyRjtBQUMzRixtQ0FBd0M7QUFrQnhDLFNBQWdCLGtCQUFrQixDQUFDLEtBQW9CLEVBQUUsS0FBOEI7SUFDbkYsc0NBQXNDO0lBQ3RDLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEVBQUU7UUFDekIsMkNBQTJDO1FBQzNDLElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQ3hCLE1BQU0sZ0JBQWdCLEdBQUcscUJBQWEsQ0FBQywyQ0FBaUIsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztZQUNsRixPQUFPLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLGdCQUFnQixDQUFDLENBQUM7U0FDckU7YUFBTTtZQUNILE9BQU8sSUFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUUsMkNBQWlCLENBQUMsQ0FBQztTQUN0RTtLQUNKO1NBQU07UUFDSCxPQUFPLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztLQUNqQztBQUNMLENBQUM7QUFiRCxnREFhQztBQUVELFNBQWdCLDRCQUE0QixDQUFDLEtBQW9CLEVBQUUsS0FBOEI7SUFDN0Ysc0NBQXNDO0lBQ3RDLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEVBQUU7UUFDekIsMkNBQTJDO1FBQzNDLElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQ3hCLE1BQU0sZ0JBQWdCLEdBQUcscUJBQWEsQ0FBQyxxREFBMkIsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztZQUM1RixPQUFPLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLGdCQUFnQixDQUFDLENBQUM7U0FDckU7YUFBTTtZQUNILE9BQU8sSUFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUUscURBQTJCLENBQUMsQ0FBQztTQUNoRjtLQUNKO1NBQU07UUFDSCxPQUFPLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztLQUNqQztBQUNMLENBQUM7QUFiRCxvRUFhQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDE5IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgZHluYW1vZGIgZnJvbSAnQGF3cy1jZGsvYXdzLWR5bmFtb2RiJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IERlZmF1bHRUYWJsZVByb3BzLCBEZWZhdWx0VGFibGVXaXRoU3RyZWFtUHJvcHMgfSBmcm9tICcuL2R5bmFtb2RiLXRhYmxlLWRlZmF1bHRzJztcbmltcG9ydCB7IG92ZXJyaWRlUHJvcHMgfSBmcm9tICcuL3V0aWxzJztcblxuZXhwb3J0IGludGVyZmFjZSBCdWlsZER5bmFtb0RCVGFibGVQcm9wcyB7XG4gIC8qKlxuICAgKiBPcHRpb25hbCB1c2VyIHByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgZHluYW1vVGFibGVQcm9wcz86IGR5bmFtb2RiLlRhYmxlUHJvcHMsXG4gIC8qKlxuICAgKiBFeGlzdGluZyBpbnN0YW5jZSBvZiBkeW5hbW9kYiB0YWJsZSBvYmplY3QuXG4gICAqIElmIHRoaXMgaXMgc2V0IHRoZW4gdGhlIGR5bmFtb1RhYmxlUHJvcHMgaXMgaWdub3JlZFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nVGFibGVPYmo/OiBkeW5hbW9kYi5UYWJsZVxufVxuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGREeW5hbW9EQlRhYmxlKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBwcm9wczogQnVpbGREeW5hbW9EQlRhYmxlUHJvcHMpOiBkeW5hbW9kYi5UYWJsZSB7XG4gICAgLy8gQ29uZGl0aW9uYWwgRHluYW1vREIgVGFibGUgY3JlYXRpb25cbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nVGFibGVPYmopIHtcbiAgICAgICAgLy8gU2V0IHRoZSBkZWZhdWx0IHByb3BzIGZvciBEeW5hbW9EQiB0YWJsZVxuICAgICAgICBpZiAocHJvcHMuZHluYW1vVGFibGVQcm9wcykge1xuICAgICAgICAgICAgY29uc3QgZHluYW1vVGFibGVQcm9wcyA9IG92ZXJyaWRlUHJvcHMoRGVmYXVsdFRhYmxlUHJvcHMsIHByb3BzLmR5bmFtb1RhYmxlUHJvcHMpO1xuICAgICAgICAgICAgcmV0dXJuIG5ldyBkeW5hbW9kYi5UYWJsZShzY29wZSwgJ0R5bmFtb1RhYmxlJywgZHluYW1vVGFibGVQcm9wcyk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICByZXR1cm4gbmV3IGR5bmFtb2RiLlRhYmxlKHNjb3BlLCAnRHluYW1vVGFibGUnLCBEZWZhdWx0VGFibGVQcm9wcyk7XG4gICAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gcHJvcHMuZXhpc3RpbmdUYWJsZU9iajtcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBidWlsZER5bmFtb0RCVGFibGVXaXRoU3RyZWFtKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBwcm9wczogQnVpbGREeW5hbW9EQlRhYmxlUHJvcHMpOiBkeW5hbW9kYi5UYWJsZSB7XG4gICAgLy8gQ29uZGl0aW9uYWwgRHluYW1vREIgVGFibGUgY3JlYXRpb25cbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nVGFibGVPYmopIHtcbiAgICAgICAgLy8gU2V0IHRoZSBkZWZhdWx0IHByb3BzIGZvciBEeW5hbW9EQiB0YWJsZVxuICAgICAgICBpZiAocHJvcHMuZHluYW1vVGFibGVQcm9wcykge1xuICAgICAgICAgICAgY29uc3QgZHluYW1vVGFibGVQcm9wcyA9IG92ZXJyaWRlUHJvcHMoRGVmYXVsdFRhYmxlV2l0aFN0cmVhbVByb3BzLCBwcm9wcy5keW5hbW9UYWJsZVByb3BzKTtcbiAgICAgICAgICAgIHJldHVybiBuZXcgZHluYW1vZGIuVGFibGUoc2NvcGUsICdEeW5hbW9UYWJsZScsIGR5bmFtb1RhYmxlUHJvcHMpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuIG5ldyBkeW5hbW9kYi5UYWJsZShzY29wZSwgJ0R5bmFtb1RhYmxlJywgRGVmYXVsdFRhYmxlV2l0aFN0cmVhbVByb3BzKTtcbiAgICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBwcm9wcy5leGlzdGluZ1RhYmxlT2JqO1xuICAgIH1cbn0iXX0=