from .features import Dictionary, RegexMatches, Stopwords

name = "serbian"

try:
    import enchant
    dictionary = enchant.Dict("sr")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'sr'.  " +
                      "Consider installing 'hunspell-sr'.")

dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
`enchant.Dict <https://github.com/rfk/pyenchant>`_ "sr". Provided by `hunspell-sr`.
"""

# https://meta.wikimedia.org/w/index.php?oldid=17213519
stopwords = [
    r"административна",
    r"административног",
    r"али",
    r"америчке",
    r"америчких",
    r"астрономија",
    r"база",
    r"без",
    r"београд",
    r"била",
    r"били",
    r"било",
    r"био",
    r"биографија",
    r"бити",
    r"босна",
    r"број",
    r"броја",
    r"броју",
    r"везе",
    r"век",
    r"века",
    r"велики",
    r"већ",
    r"види",
    r"висина",
    r"висини",
    r"више",
    r"вода",
    r"време",
    r"где",
    r"гдуж",
    r"географија",
    r"географског",
    r"главни",
    r"год",
    r"година",
    r"године",
    r"град",
    r"града",
    r"градова",
    r"градови",
    r"график",
    r"графика",
    r"грб",
    r"гшир",
    r"дан",
    r"дана",
    r"данас",
    r"датотека",
    r"датум",
    r"два",
    r"две",
    r"демографија",
    r"демографијафр",
    r"део",
    r"департм",
    r"десно",
    r"деценијама",
    r"док",
    r"држава",
    r"државе",
    r"други",
    r"друго",
    r"живело",
    r"животиње",
    r"живјело",
    r"завод",
    r"зас",
    r"застава",
    r"због",
    r"значење",
    r"игд",
    r"извор",
    r"извори",
    r"између",
    r"или",
    r"има",
    r"име",
    r"института",
    r"интерактивни",
    r"историја",
    r"када",
    r"како",
    r"кантон",
    r"као",
    r"касније",
    r"категорија",
    r"километража",
    r"клица",
    r"код",
    r"координате",
    r"копно",
    r"која",
    r"које",
    r"који",
    r"коју",
    r"крај",
    r"књига",
    r"лево",
    r"литература",
    r"максимална",
    r"максималној",
    r"мапа",
    r"мапе",
    r"мапи",
    r"мај",
    r"месец",
    r"места",
    r"место",
    r"метара",
    r"међу",
    r"мини",
    r"минимална",
    r"минималној",
    r"може",
    r"мјесту",
    r"надм",
    r"надморској",
    r"назив",
    r"након",
    r"налази",
    r"напомене",
    r"насеља",
    r"насеље",
    r"насељена",
    r"насељено",
    r"наслов",
    r"националног",
    r"најближа",
    r"највећи",
    r"неколико",
    r"немачка",
    r"нису",
    r"није",
    r"нови",
    r"ова",
    r"овај",
    r"ове",
    r"ово",
    r"овом",
    r"овој",
    r"одредница",
    r"око",
    r"окрузи",
    r"опис",
    r"општина",
    r"општини",
    r"организације",
    r"оригинал",
    r"оригинални",
    r"основним",
    r"пиксела",
    r"план",
    r"површина",
    r"површини",
    r"под",
    r"подела",
    r"позиција",
    r"положај",
    r"попис",
    r"популација",
    r"поред",
    r"портал",
    r"посебно",
    r"после",
    r"последњих",
    r"почетак",
    r"правац",
    r"прва",
    r"први",
    r"пре",
    r"председник",
    r"презиме",
    r"преко",
    r"према",
    r"преусмери",
    r"префектура",
    r"префектури",
    r"припада",
    r"приступљено",
    r"промене",
    r"простире",
    r"процјени",
    r"пројекти",
    r"пуно",
    r"пут",
    r"рат",
    r"рата",
    r"република",
    r"републике",
    r"референце",
    r"рођени",
    r"рођења",
    r"сад",
    r"само",
    r"сајту",
    r"све",
    r"своје",
    r"сгш",
    r"септембар",
    r"слика",
    r"слике",
    r"службовања",
    r"смрти",
    r"списак",
    r"спољашње",
    r"срби",
    r"србија",
    r"србије",
    r"србији",
    r"средњој",
    r"српска",
    r"српски",
    r"становника",
    r"становништва",
    r"становништво",
    r"статистику",
    r"статуса",
    r"стране",
    r"страници",
    r"сфрј",
    r"сједињене",
    r"сједињених",
    r"тада",
    r"тако",
    r"такође",
    r"текст",
    r"тим",
    r"тога",
    r"током",
    r"току",
    r"три",
    r"укупно",
    r"умрли",
    r"фајлу",
    r"фра",
    r"француске",
    r"ширина",
    r"што",
    r"један",
    r"једна",
    r"јез",
    r"језик",
    r"јер",
    r"још",
    r"југославија",
    r"југославије",
    r"јул",
    r"јун",
]

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
https://meta.wikimedia.org/w/index.php?oldid=17213519
"""

badword_regexes = [
    r"геј",
    r"говна",
    r"говно",
    r"далматии",
    r"јебање",
    r"јебач",
    r"јебе",
    r"јебем",
    r"јебига",
    r"јебите",
    r"јебо",
    r"компније",
    r"курац",
    r"курца",
    r"курчина",
    r"лезбејка",
    r"мажарскога",
    r"мажарску",
    r"педер",
    r"педери",
    r"педерима",
    r"педерски",
    r"педеру",
    r"пизда",
    r"пизде",
    r"пиздо",
    r"пизду",
    r"пичка",
    r"пичке",
    r"пичко",
    r"пичку",
    r"срање",
    r"шупак",
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"ђе",
    r"исплњени",
    r"коњу",
    r"многија",
    r"многими",
    r"мнози",
    r"покраше",
    r"серба",
    r"сербија",
    r"сербије",
    r"сербији",
    r"серпска",
    r"серпске",
    r"серпски",
    r"серпским",
    r"серпског",
    r"серпској",
    r"серпскохрватским",
    r"србске",
    r"србским",
    r"србских",
    r"србског",
    r"србској",
    r"србску",
    r"хабзбзрге",
    r"хаха",
    r"хахаха",
    r"хахахаха",
    r"хахахахаха",
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
