"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDeliveryStreamProps = void 0;
function DefaultCfnDeliveryStreamProps(_bucketArn, _roleArn, _logGroupName, _logStreamName, _kms) {
    return {
        extendedS3DestinationConfiguration: {
            bucketArn: _bucketArn,
            bufferingHints: {
                intervalInSeconds: 300,
                sizeInMBs: 5
            },
            compressionFormat: 'GZIP',
            roleArn: _roleArn,
            cloudWatchLoggingOptions: {
                enabled: true,
                logGroupName: _logGroupName,
                logStreamName: _logStreamName
            },
            encryptionConfiguration: {
                kmsEncryptionConfig: {
                    awskmsKeyArn: _kms.keyArn
                }
            }
        },
    };
}
exports.DefaultCfnDeliveryStreamProps = DefaultCfnDeliveryStreamProps;
//# sourceMappingURL=data:application/json;base64,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