/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as cache from "aws-cdk-lib/aws-elasticache";
import { Construct } from "constructs";
export interface ObtainMemcachedClusterProps {
    readonly cachePort?: any;
    readonly cacheSecurityGroupId: string;
    readonly cacheProps?: cache.CfnCacheClusterProps | any;
    readonly existingCache?: cache.CfnCacheCluster;
    readonly vpc?: ec2.IVpc;
}
export declare function obtainMemcachedCluster(scope: Construct, id: string, props: ObtainMemcachedClusterProps): cache.CfnCacheCluster;
export declare function createCacheSubnetGroup(construct: Construct, vpc: ec2.IVpc, id: string): cache.CfnSubnetGroup;
export declare function getCachePort(clientCacheProps?: cache.CfnCacheClusterProps | any, existingCache?: cache.CfnCacheCluster): any;
