from typing import TYPE_CHECKING

from ..types.chats import ChatMember

from ..enums.http_method import HTTPMethod
from ..enums.api_path import ApiPath

from ..connection.base import BaseConnection


if TYPE_CHECKING:
    from ..bot import Bot


class GetMeFromChat(BaseConnection):
    
    """
    Класс для получения информации о текущем боте в конкретном чате.

    Args:
        bot (Bot): Экземпляр бота для выполнения запроса.
        chat_id (int): Идентификатор чата.

    Attributes:
        bot (Bot): Экземпляр бота.
        chat_id (int): Идентификатор чата.
    """
    
    def __init__(
            self, 
            bot: 'Bot',
            chat_id: int
        ):
        self.bot = bot
        self.chat_id = chat_id

    async def request(self) -> ChatMember:
        
        """
        Выполняет GET-запрос для получения информации о боте в указанном чате.

        Returns:
            ChatMember: Информация о боте как участнике чата.
        """
        
        return await super().request(
            method=HTTPMethod.GET, 
            path=ApiPath.CHATS + '/' + str(self.chat_id) + ApiPath.MEMBERS + ApiPath.ME,
            model=ChatMember,
            params=self.bot.params
        )