# coding: utf-8

"""
Copyright (c) 2021 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import OperateParameter

class WorksheetOperateParameter(OperateParameter):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'sheet_type': 'str',
        'new_name': 'str',
        'moving_request': 'WorksheetMovingRequest'
    }

    attribute_map = {
        'name': 'Name',
        'sheet_type': 'SheetType',
        'new_name': 'NewName',
        'moving_request': 'MovingRequest'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(WorksheetOperateParameter.swagger_types, **OperateParameter.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(WorksheetOperateParameter.attribute_map, **OperateParameter.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, name=None, sheet_type=None, new_name=None, moving_request=None, **kw):
        super(WorksheetOperateParameter, self).__init__(**kw)
		    
        """
        WorksheetOperateParameter - a model defined in Swagger
        """

        self.container['name'] = None
        self.container['sheet_type'] = None
        self.container['new_name'] = None
        self.container['moving_request'] = None

        if name is not None:
          self.name = name
        if sheet_type is not None:
          self.sheet_type = sheet_type
        if new_name is not None:
          self.new_name = new_name
        if moving_request is not None:
          self.moving_request = moving_request

    @property
    def name(self):
        """
        Gets the name of this WorksheetOperateParameter.

        :return: The name of this WorksheetOperateParameter.
        :rtype: str
        """
        return self.container['name']

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorksheetOperateParameter.

        :param name: The name of this WorksheetOperateParameter.
        :type: str
        """

        self.container['name'] = name

    @property
    def sheet_type(self):
        """
        Gets the sheet_type of this WorksheetOperateParameter.

        :return: The sheet_type of this WorksheetOperateParameter.
        :rtype: str
        """
        return self.container['sheet_type']

    @sheet_type.setter
    def sheet_type(self, sheet_type):
        """
        Sets the sheet_type of this WorksheetOperateParameter.

        :param sheet_type: The sheet_type of this WorksheetOperateParameter.
        :type: str
        """

        self.container['sheet_type'] = sheet_type

    @property
    def new_name(self):
        """
        Gets the new_name of this WorksheetOperateParameter.

        :return: The new_name of this WorksheetOperateParameter.
        :rtype: str
        """
        return self.container['new_name']

    @new_name.setter
    def new_name(self, new_name):
        """
        Sets the new_name of this WorksheetOperateParameter.

        :param new_name: The new_name of this WorksheetOperateParameter.
        :type: str
        """

        self.container['new_name'] = new_name

    @property
    def moving_request(self):
        """
        Gets the moving_request of this WorksheetOperateParameter.

        :return: The moving_request of this WorksheetOperateParameter.
        :rtype: WorksheetMovingRequest
        """
        return self.container['moving_request']

    @moving_request.setter
    def moving_request(self, moving_request):
        """
        Sets the moving_request of this WorksheetOperateParameter.

        :param moving_request: The moving_request of this WorksheetOperateParameter.
        :type: WorksheetMovingRequest
        """

        self.container['moving_request'] = moving_request

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WorksheetOperateParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
