# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import SaveOptions

class TxtSaveOptions(SaveOptions):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quote_type': 'str',
        'separator': 'str',
        'separator_string': 'str',
        'always_quoted': 'bool'
    }

    attribute_map = {
        'quote_type': 'QuoteType',
        'separator': 'Separator',
        'separator_string': 'SeparatorString',
        'always_quoted': 'AlwaysQuoted'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(TxtSaveOptions.swagger_types, **SaveOptions.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(TxtSaveOptions.attribute_map, **SaveOptions.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, quote_type=None, separator=None, separator_string=None, always_quoted=None, **kw):
        super(TxtSaveOptions, self).__init__(**kw)
		    
        """
        TxtSaveOptions - a model defined in Swagger
        """

        self.container['quote_type'] = None
        self.container['separator'] = None
        self.container['separator_string'] = None
        self.container['always_quoted'] = None

        if quote_type is not None:
          self.quote_type = quote_type
        if separator is not None:
          self.separator = separator
        if separator_string is not None:
          self.separator_string = separator_string
        if always_quoted is not None:
          self.always_quoted = always_quoted

    @property
    def quote_type(self):
        """
        Gets the quote_type of this TxtSaveOptions.

        :return: The quote_type of this TxtSaveOptions.
        :rtype: str
        """
        return self.container['quote_type']

    @quote_type.setter
    def quote_type(self, quote_type):
        """
        Sets the quote_type of this TxtSaveOptions.

        :param quote_type: The quote_type of this TxtSaveOptions.
        :type: str
        """

        self.container['quote_type'] = quote_type

    @property
    def separator(self):
        """
        Gets the separator of this TxtSaveOptions.

        :return: The separator of this TxtSaveOptions.
        :rtype: str
        """
        return self.container['separator']

    @separator.setter
    def separator(self, separator):
        """
        Sets the separator of this TxtSaveOptions.

        :param separator: The separator of this TxtSaveOptions.
        :type: str
        """

        self.container['separator'] = separator

    @property
    def separator_string(self):
        """
        Gets the separator_string of this TxtSaveOptions.

        :return: The separator_string of this TxtSaveOptions.
        :rtype: str
        """
        return self.container['separator_string']

    @separator_string.setter
    def separator_string(self, separator_string):
        """
        Sets the separator_string of this TxtSaveOptions.

        :param separator_string: The separator_string of this TxtSaveOptions.
        :type: str
        """

        self.container['separator_string'] = separator_string

    @property
    def always_quoted(self):
        """
        Gets the always_quoted of this TxtSaveOptions.

        :return: The always_quoted of this TxtSaveOptions.
        :rtype: bool
        """
        return self.container['always_quoted']

    @always_quoted.setter
    def always_quoted(self, always_quoted):
        """
        Sets the always_quoted of this TxtSaveOptions.

        :param always_quoted: The always_quoted of this TxtSaveOptions.
        :type: bool
        """

        self.container['always_quoted'] = always_quoted

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TxtSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
