# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Top10(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_bottom': 'bool',
        'is_percent': 'bool',
        'rank': 'int'
    }

    attribute_map = {
        'is_bottom': 'IsBottom',
        'is_percent': 'IsPercent',
        'rank': 'Rank'
    }
    
    @staticmethod
    def get_swagger_types():
        return Top10.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Top10.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, is_bottom=None, is_percent=None, rank=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Top10 - a model defined in Swagger
        """

        self.container['is_bottom'] = None
        self.container['is_percent'] = None
        self.container['rank'] = None

        if is_bottom is not None:
          self.is_bottom = is_bottom
        if is_percent is not None:
          self.is_percent = is_percent
        if rank is not None:
          self.rank = rank

    @property
    def is_bottom(self):
        """
        Gets the is_bottom of this Top10.
        Get or set the flag indicating whether a \"top/bottom n\" rule is a \"bottom    n\" rule. '1' indicates 'bottom'.  Default value is false.             

        :return: The is_bottom of this Top10.
        :rtype: bool
        """
        return self.container['is_bottom']

    @is_bottom.setter
    def is_bottom(self, is_bottom):
        """
        Sets the is_bottom of this Top10.
        Get or set the flag indicating whether a \"top/bottom n\" rule is a \"bottom    n\" rule. '1' indicates 'bottom'.  Default value is false.             

        :param is_bottom: The is_bottom of this Top10.
        :type: bool
        """

        self.container['is_bottom'] = is_bottom

    @property
    def is_percent(self):
        """
        Gets the is_percent of this Top10.
        Get or set the flag indicating whether a \"top/bottom n\" rule is a \"top/bottom     n percent\" rule.  Default value is false.

        :return: The is_percent of this Top10.
        :rtype: bool
        """
        return self.container['is_percent']

    @is_percent.setter
    def is_percent(self, is_percent):
        """
        Sets the is_percent of this Top10.
        Get or set the flag indicating whether a \"top/bottom n\" rule is a \"top/bottom     n percent\" rule.  Default value is false.

        :param is_percent: The is_percent of this Top10.
        :type: bool
        """

        self.container['is_percent'] = is_percent

    @property
    def rank(self):
        """
        Gets the rank of this Top10.
        Get or set the value of \"n\" in a \"top/bottom n\" conditional formatting rule.      If IsPercent is true, the value must between 0 and 100.  Otherwise it must     between 0 and 1000.  Default value is 10.

        :return: The rank of this Top10.
        :rtype: int
        """
        return self.container['rank']

    @rank.setter
    def rank(self, rank):
        """
        Sets the rank of this Top10.
        Get or set the value of \"n\" in a \"top/bottom n\" conditional formatting rule.      If IsPercent is true, the value must between 0 and 100.  Otherwise it must     between 0 and 1000.  Default value is 10.

        :param rank: The rank of this Top10.
        :type: int
        """

        self.container['rank'] = rank

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Top10):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
