# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class TilePicOption(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alignment_type': 'str',
        'offset_x': 'float',
        'scale_x': 'float',
        'offset_y': 'float',
        'scale_y': 'float',
        'mirror_type': 'str'
    }

    attribute_map = {
        'alignment_type': 'AlignmentType',
        'offset_x': 'OffsetX',
        'scale_x': 'ScaleX',
        'offset_y': 'OffsetY',
        'scale_y': 'ScaleY',
        'mirror_type': 'MirrorType'
    }
    
    @staticmethod
    def get_swagger_types():
        return TilePicOption.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return TilePicOption.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, alignment_type=None, offset_x=None, scale_x=None, offset_y=None, scale_y=None, mirror_type=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        TilePicOption - a model defined in Swagger
        """

        self.container['alignment_type'] = None
        self.container['offset_x'] = None
        self.container['scale_x'] = None
        self.container['offset_y'] = None
        self.container['scale_y'] = None
        self.container['mirror_type'] = None

        if alignment_type is not None:
          self.alignment_type = alignment_type
        self.offset_x = offset_x
        self.scale_x = scale_x
        self.offset_y = offset_y
        self.scale_y = scale_y
        if mirror_type is not None:
          self.mirror_type = mirror_type

    @property
    def alignment_type(self):
        """
        Gets the alignment_type of this TilePicOption.

        :return: The alignment_type of this TilePicOption.
        :rtype: str
        """
        return self.container['alignment_type']

    @alignment_type.setter
    def alignment_type(self, alignment_type):
        """
        Sets the alignment_type of this TilePicOption.

        :param alignment_type: The alignment_type of this TilePicOption.
        :type: str
        """

        self.container['alignment_type'] = alignment_type

    @property
    def offset_x(self):
        """
        Gets the offset_x of this TilePicOption.

        :return: The offset_x of this TilePicOption.
        :rtype: float
        """
        return self.container['offset_x']

    @offset_x.setter
    def offset_x(self, offset_x):
        """
        Sets the offset_x of this TilePicOption.

        :param offset_x: The offset_x of this TilePicOption.
        :type: float
        """
        """
        if offset_x is None:
            raise ValueError("Invalid value for `offset_x`, must not be `None`")
        """

        self.container['offset_x'] = offset_x

    @property
    def scale_x(self):
        """
        Gets the scale_x of this TilePicOption.

        :return: The scale_x of this TilePicOption.
        :rtype: float
        """
        return self.container['scale_x']

    @scale_x.setter
    def scale_x(self, scale_x):
        """
        Sets the scale_x of this TilePicOption.

        :param scale_x: The scale_x of this TilePicOption.
        :type: float
        """
        """
        if scale_x is None:
            raise ValueError("Invalid value for `scale_x`, must not be `None`")
        """

        self.container['scale_x'] = scale_x

    @property
    def offset_y(self):
        """
        Gets the offset_y of this TilePicOption.

        :return: The offset_y of this TilePicOption.
        :rtype: float
        """
        return self.container['offset_y']

    @offset_y.setter
    def offset_y(self, offset_y):
        """
        Sets the offset_y of this TilePicOption.

        :param offset_y: The offset_y of this TilePicOption.
        :type: float
        """
        """
        if offset_y is None:
            raise ValueError("Invalid value for `offset_y`, must not be `None`")
        """

        self.container['offset_y'] = offset_y

    @property
    def scale_y(self):
        """
        Gets the scale_y of this TilePicOption.

        :return: The scale_y of this TilePicOption.
        :rtype: float
        """
        return self.container['scale_y']

    @scale_y.setter
    def scale_y(self, scale_y):
        """
        Sets the scale_y of this TilePicOption.

        :param scale_y: The scale_y of this TilePicOption.
        :type: float
        """
        """
        if scale_y is None:
            raise ValueError("Invalid value for `scale_y`, must not be `None`")
        """

        self.container['scale_y'] = scale_y

    @property
    def mirror_type(self):
        """
        Gets the mirror_type of this TilePicOption.

        :return: The mirror_type of this TilePicOption.
        :rtype: str
        """
        return self.container['mirror_type']

    @mirror_type.setter
    def mirror_type(self, mirror_type):
        """
        Sets the mirror_type of this TilePicOption.

        :param mirror_type: The mirror_type of this TilePicOption.
        :type: str
        """

        self.container['mirror_type'] = mirror_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TilePicOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
