# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class TableTotalRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'list_column_index': 'int',
        'totals_calculation': 'str',
        'custom_formula': 'str'
    }

    attribute_map = {
        'list_column_index': 'ListColumnIndex',
        'totals_calculation': 'TotalsCalculation',
        'custom_formula': 'CustomFormula'
    }
    
    @staticmethod
    def get_swagger_types():
        return TableTotalRequest.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return TableTotalRequest.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, list_column_index=None, totals_calculation=None, custom_formula=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        TableTotalRequest - a model defined in Swagger
        """

        self.container['list_column_index'] = None
        self.container['totals_calculation'] = None
        self.container['custom_formula'] = None

        if list_column_index is not None:
          self.list_column_index = list_column_index
        if totals_calculation is not None:
          self.totals_calculation = totals_calculation
        if custom_formula is not None:
          self.custom_formula = custom_formula

    @property
    def list_column_index(self):
        """
        Gets the list_column_index of this TableTotalRequest.

        :return: The list_column_index of this TableTotalRequest.
        :rtype: int
        """
        return self.container['list_column_index']

    @list_column_index.setter
    def list_column_index(self, list_column_index):
        """
        Sets the list_column_index of this TableTotalRequest.

        :param list_column_index: The list_column_index of this TableTotalRequest.
        :type: int
        """

        self.container['list_column_index'] = list_column_index

    @property
    def totals_calculation(self):
        """
        Gets the totals_calculation of this TableTotalRequest.

        :return: The totals_calculation of this TableTotalRequest.
        :rtype: str
        """
        return self.container['totals_calculation']

    @totals_calculation.setter
    def totals_calculation(self, totals_calculation):
        """
        Sets the totals_calculation of this TableTotalRequest.

        :param totals_calculation: The totals_calculation of this TableTotalRequest.
        :type: str
        """

        self.container['totals_calculation'] = totals_calculation

    @property
    def custom_formula(self):
        """
        Gets the custom_formula of this TableTotalRequest.

        :return: The custom_formula of this TableTotalRequest.
        :rtype: str
        """
        return self.container['custom_formula']

    @custom_formula.setter
    def custom_formula(self, custom_formula):
        """
        Sets the custom_formula of this TableTotalRequest.

        :param custom_formula: The custom_formula of this TableTotalRequest.
        :type: str
        """

        self.container['custom_formula'] = custom_formula

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TableTotalRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
