# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import SaveOptions

class SqlScriptSaveOptions(SaveOptions):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'check_if_table_exists': 'bool',
        'column_type_map': 'str',
        'check_all_data_for_column_type': 'bool',
        'add_blank_line_between_rows': 'bool',
        'operator_type': 'str',
        'create_table': 'bool',
        'id_name': 'str',
        'start_id': 'int',
        'table_name': 'str',
        'export_as_string': 'bool',
        'export_area': 'CellArea',
        'has_header_row': 'bool'
    }

    attribute_map = {
        'check_if_table_exists': 'CheckIfTableExists',
        'column_type_map': 'ColumnTypeMap',
        'check_all_data_for_column_type': 'CheckAllDataForColumnType',
        'add_blank_line_between_rows': 'AddBlankLineBetweenRows',
        'operator_type': 'OperatorType',
        'create_table': 'CreateTable',
        'id_name': 'IdName',
        'start_id': 'StartId',
        'table_name': 'TableName',
        'export_as_string': 'ExportAsString',
        'export_area': 'ExportArea',
        'has_header_row': 'HasHeaderRow'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(SqlScriptSaveOptions.swagger_types, **SaveOptions.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(SqlScriptSaveOptions.attribute_map, **SaveOptions.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, check_if_table_exists=None, column_type_map=None, check_all_data_for_column_type=None, add_blank_line_between_rows=None, operator_type=None, create_table=None, id_name=None, start_id=None, table_name=None, export_as_string=None, export_area=None, has_header_row=None, **kw):
        super(SqlScriptSaveOptions, self).__init__(**kw)
		    
        """
        SqlScriptSaveOptions - a model defined in Swagger
        """

        self.container['check_if_table_exists'] = None
        self.container['column_type_map'] = None
        self.container['check_all_data_for_column_type'] = None
        self.container['add_blank_line_between_rows'] = None
        self.container['operator_type'] = None
        self.container['create_table'] = None
        self.container['id_name'] = None
        self.container['start_id'] = None
        self.container['table_name'] = None
        self.container['export_as_string'] = None
        self.container['export_area'] = None
        self.container['has_header_row'] = None

        if check_if_table_exists is not None:
          self.check_if_table_exists = check_if_table_exists
        if column_type_map is not None:
          self.column_type_map = column_type_map
        if check_all_data_for_column_type is not None:
          self.check_all_data_for_column_type = check_all_data_for_column_type
        if add_blank_line_between_rows is not None:
          self.add_blank_line_between_rows = add_blank_line_between_rows
        if operator_type is not None:
          self.operator_type = operator_type
        if create_table is not None:
          self.create_table = create_table
        if id_name is not None:
          self.id_name = id_name
        if start_id is not None:
          self.start_id = start_id
        if table_name is not None:
          self.table_name = table_name
        if export_as_string is not None:
          self.export_as_string = export_as_string
        if export_area is not None:
          self.export_area = export_area
        if has_header_row is not None:
          self.has_header_row = has_header_row

    @property
    def check_if_table_exists(self):
        """
        Gets the check_if_table_exists of this SqlScriptSaveOptions.

        :return: The check_if_table_exists of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['check_if_table_exists']

    @check_if_table_exists.setter
    def check_if_table_exists(self, check_if_table_exists):
        """
        Sets the check_if_table_exists of this SqlScriptSaveOptions.

        :param check_if_table_exists: The check_if_table_exists of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['check_if_table_exists'] = check_if_table_exists

    @property
    def column_type_map(self):
        """
        Gets the column_type_map of this SqlScriptSaveOptions.

        :return: The column_type_map of this SqlScriptSaveOptions.
        :rtype: str
        """
        return self.container['column_type_map']

    @column_type_map.setter
    def column_type_map(self, column_type_map):
        """
        Sets the column_type_map of this SqlScriptSaveOptions.

        :param column_type_map: The column_type_map of this SqlScriptSaveOptions.
        :type: str
        """

        self.container['column_type_map'] = column_type_map

    @property
    def check_all_data_for_column_type(self):
        """
        Gets the check_all_data_for_column_type of this SqlScriptSaveOptions.

        :return: The check_all_data_for_column_type of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['check_all_data_for_column_type']

    @check_all_data_for_column_type.setter
    def check_all_data_for_column_type(self, check_all_data_for_column_type):
        """
        Sets the check_all_data_for_column_type of this SqlScriptSaveOptions.

        :param check_all_data_for_column_type: The check_all_data_for_column_type of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['check_all_data_for_column_type'] = check_all_data_for_column_type

    @property
    def add_blank_line_between_rows(self):
        """
        Gets the add_blank_line_between_rows of this SqlScriptSaveOptions.

        :return: The add_blank_line_between_rows of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['add_blank_line_between_rows']

    @add_blank_line_between_rows.setter
    def add_blank_line_between_rows(self, add_blank_line_between_rows):
        """
        Sets the add_blank_line_between_rows of this SqlScriptSaveOptions.

        :param add_blank_line_between_rows: The add_blank_line_between_rows of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['add_blank_line_between_rows'] = add_blank_line_between_rows

    @property
    def operator_type(self):
        """
        Gets the operator_type of this SqlScriptSaveOptions.

        :return: The operator_type of this SqlScriptSaveOptions.
        :rtype: str
        """
        return self.container['operator_type']

    @operator_type.setter
    def operator_type(self, operator_type):
        """
        Sets the operator_type of this SqlScriptSaveOptions.

        :param operator_type: The operator_type of this SqlScriptSaveOptions.
        :type: str
        """

        self.container['operator_type'] = operator_type

    @property
    def create_table(self):
        """
        Gets the create_table of this SqlScriptSaveOptions.

        :return: The create_table of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['create_table']

    @create_table.setter
    def create_table(self, create_table):
        """
        Sets the create_table of this SqlScriptSaveOptions.

        :param create_table: The create_table of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['create_table'] = create_table

    @property
    def id_name(self):
        """
        Gets the id_name of this SqlScriptSaveOptions.

        :return: The id_name of this SqlScriptSaveOptions.
        :rtype: str
        """
        return self.container['id_name']

    @id_name.setter
    def id_name(self, id_name):
        """
        Sets the id_name of this SqlScriptSaveOptions.

        :param id_name: The id_name of this SqlScriptSaveOptions.
        :type: str
        """

        self.container['id_name'] = id_name

    @property
    def start_id(self):
        """
        Gets the start_id of this SqlScriptSaveOptions.

        :return: The start_id of this SqlScriptSaveOptions.
        :rtype: int
        """
        return self.container['start_id']

    @start_id.setter
    def start_id(self, start_id):
        """
        Sets the start_id of this SqlScriptSaveOptions.

        :param start_id: The start_id of this SqlScriptSaveOptions.
        :type: int
        """

        self.container['start_id'] = start_id

    @property
    def table_name(self):
        """
        Gets the table_name of this SqlScriptSaveOptions.

        :return: The table_name of this SqlScriptSaveOptions.
        :rtype: str
        """
        return self.container['table_name']

    @table_name.setter
    def table_name(self, table_name):
        """
        Sets the table_name of this SqlScriptSaveOptions.

        :param table_name: The table_name of this SqlScriptSaveOptions.
        :type: str
        """

        self.container['table_name'] = table_name

    @property
    def export_as_string(self):
        """
        Gets the export_as_string of this SqlScriptSaveOptions.

        :return: The export_as_string of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['export_as_string']

    @export_as_string.setter
    def export_as_string(self, export_as_string):
        """
        Sets the export_as_string of this SqlScriptSaveOptions.

        :param export_as_string: The export_as_string of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['export_as_string'] = export_as_string

    @property
    def export_area(self):
        """
        Gets the export_area of this SqlScriptSaveOptions.

        :return: The export_area of this SqlScriptSaveOptions.
        :rtype: CellArea
        """
        return self.container['export_area']

    @export_area.setter
    def export_area(self, export_area):
        """
        Sets the export_area of this SqlScriptSaveOptions.

        :param export_area: The export_area of this SqlScriptSaveOptions.
        :type: CellArea
        """

        self.container['export_area'] = export_area

    @property
    def has_header_row(self):
        """
        Gets the has_header_row of this SqlScriptSaveOptions.

        :return: The has_header_row of this SqlScriptSaveOptions.
        :rtype: bool
        """
        return self.container['has_header_row']

    @has_header_row.setter
    def has_header_row(self, has_header_row):
        """
        Sets the has_header_row of this SqlScriptSaveOptions.

        :param has_header_row: The has_header_row of this SqlScriptSaveOptions.
        :type: bool
        """

        self.container['has_header_row'] = has_header_row

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SqlScriptSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
