# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Sparkline(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'column': 'int',
        'data_range': 'str',
        'row': 'int'
    }

    attribute_map = {
        'column': 'Column',
        'data_range': 'DataRange',
        'row': 'Row'
    }
    
    @staticmethod
    def get_swagger_types():
        return Sparkline.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Sparkline.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, column=None, data_range=None, row=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Sparkline - a model defined in Swagger
        """

        self.container['column'] = None
        self.container['data_range'] = None
        self.container['row'] = None

        self.column = column
        if data_range is not None:
          self.data_range = data_range
        self.row = row

    @property
    def column(self):
        """
        Gets the column of this Sparkline.

        :return: The column of this Sparkline.
        :rtype: int
        """
        return self.container['column']

    @column.setter
    def column(self, column):
        """
        Sets the column of this Sparkline.

        :param column: The column of this Sparkline.
        :type: int
        """
        """
        if column is None:
            raise ValueError("Invalid value for `column`, must not be `None`")
        """

        self.container['column'] = column

    @property
    def data_range(self):
        """
        Gets the data_range of this Sparkline.

        :return: The data_range of this Sparkline.
        :rtype: str
        """
        return self.container['data_range']

    @data_range.setter
    def data_range(self, data_range):
        """
        Sets the data_range of this Sparkline.

        :param data_range: The data_range of this Sparkline.
        :type: str
        """

        self.container['data_range'] = data_range

    @property
    def row(self):
        """
        Gets the row of this Sparkline.

        :return: The row of this Sparkline.
        :rtype: int
        """
        return self.container['row']

    @row.setter
    def row(self, row):
        """
        Sets the row of this Sparkline.

        :param row: The row of this Sparkline.
        :type: int
        """
        """
        if row is None:
            raise ValueError("Invalid value for `row`, must not be `None`")
        """

        self.container['row'] = row

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Sparkline):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
