# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class SortKey(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'custom_list': 'list[str]',
        'sort_order': 'str',
        'key': 'int',
        'order': 'str',
        'type': 'str',
        'index': 'int'
    }

    attribute_map = {
        'custom_list': 'CustomList',
        'sort_order': 'SortOrder',
        'key': 'Key',
        'order': 'Order',
        'type': 'Type',
        'index': 'Index'
    }
    
    @staticmethod
    def get_swagger_types():
        return SortKey.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return SortKey.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, custom_list=None, sort_order=None, key=None, order=None, type=None, index=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        SortKey - a model defined in Swagger
        """

        self.container['custom_list'] = None
        self.container['sort_order'] = None
        self.container['key'] = None
        self.container['order'] = None
        self.container['type'] = None
        self.container['index'] = None

        if custom_list is not None:
          self.custom_list = custom_list
        if sort_order is not None:
          self.sort_order = sort_order
        self.key = key
        if order is not None:
          self.order = order
        if type is not None:
          self.type = type
        if index is not None:
          self.index = index

    @property
    def custom_list(self):
        """
        Gets the custom_list of this SortKey.

        :return: The custom_list of this SortKey.
        :rtype: list[str]
        """
        return self.container['custom_list']

    @custom_list.setter
    def custom_list(self, custom_list):
        """
        Sets the custom_list of this SortKey.

        :param custom_list: The custom_list of this SortKey.
        :type: list[str]
        """

        self.container['custom_list'] = custom_list

    @property
    def sort_order(self):
        """
        Gets the sort_order of this SortKey.

        :return: The sort_order of this SortKey.
        :rtype: str
        """
        return self.container['sort_order']

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this SortKey.

        :param sort_order: The sort_order of this SortKey.
        :type: str
        """

        self.container['sort_order'] = sort_order

    @property
    def key(self):
        """
        Gets the key of this SortKey.

        :return: The key of this SortKey.
        :rtype: int
        """
        return self.container['key']

    @key.setter
    def key(self, key):
        """
        Sets the key of this SortKey.

        :param key: The key of this SortKey.
        :type: int
        """
        """
        if key is None:
            raise ValueError("Invalid value for `key`, must not be `None`")
        """

        self.container['key'] = key

    @property
    def order(self):
        """
        Gets the order of this SortKey.

        :return: The order of this SortKey.
        :rtype: str
        """
        return self.container['order']

    @order.setter
    def order(self, order):
        """
        Sets the order of this SortKey.

        :param order: The order of this SortKey.
        :type: str
        """

        self.container['order'] = order

    @property
    def type(self):
        """
        Gets the type of this SortKey.

        :return: The type of this SortKey.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this SortKey.

        :param type: The type of this SortKey.
        :type: str
        """

        self.container['type'] = type

    @property
    def index(self):
        """
        Gets the index of this SortKey.

        :return: The index of this SortKey.
        :rtype: int
        """
        return self.container['index']

    @index.setter
    def index(self, index):
        """
        Sets the index of this SortKey.

        :param index: The index of this SortKey.
        :type: int
        """

        self.container['index'] = index

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SortKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
