# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Rows(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'max_row': 'int',
        'rows_list': 'list[LinkElement]',
        'rows_count': 'int'
    }

    attribute_map = {
        'link': 'link',
        'max_row': 'MaxRow',
        'rows_list': 'RowsList',
        'rows_count': 'RowsCount'
    }
    
    @staticmethod
    def get_swagger_types():
        return Rows.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Rows.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, max_row=None, rows_list=None, rows_count=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Rows - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['max_row'] = None
        self.container['rows_list'] = None
        self.container['rows_count'] = None

        if link is not None:
          self.link = link
        self.max_row = max_row
        if rows_list is not None:
          self.rows_list = rows_list
        self.rows_count = rows_count

    @property
    def link(self):
        """
        Gets the link of this Rows.

        :return: The link of this Rows.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this Rows.

        :param link: The link of this Rows.
        :type: Link
        """

        self.container['link'] = link

    @property
    def max_row(self):
        """
        Gets the max_row of this Rows.

        :return: The max_row of this Rows.
        :rtype: int
        """
        return self.container['max_row']

    @max_row.setter
    def max_row(self, max_row):
        """
        Sets the max_row of this Rows.

        :param max_row: The max_row of this Rows.
        :type: int
        """
        """
        if max_row is None:
            raise ValueError("Invalid value for `max_row`, must not be `None`")
        """

        self.container['max_row'] = max_row

    @property
    def rows_list(self):
        """
        Gets the rows_list of this Rows.

        :return: The rows_list of this Rows.
        :rtype: list[LinkElement]
        """
        return self.container['rows_list']

    @rows_list.setter
    def rows_list(self, rows_list):
        """
        Sets the rows_list of this Rows.

        :param rows_list: The rows_list of this Rows.
        :type: list[LinkElement]
        """

        self.container['rows_list'] = rows_list

    @property
    def rows_count(self):
        """
        Gets the rows_count of this Rows.

        :return: The rows_count of this Rows.
        :rtype: int
        """
        return self.container['rows_count']

    @rows_count.setter
    def rows_count(self, rows_count):
        """
        Sets the rows_count of this Rows.

        :param rows_count: The rows_count of this Rows.
        :type: int
        """
        """
        if rows_count is None:
            raise ValueError("Invalid value for `rows_count`, must not be `None`")
        """

        self.container['rows_count'] = rows_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Rows):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
