# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Row(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'index': 'int',
        'style': 'LinkElement',
        'group_level': 'int',
        'height': 'float',
        'is_height_matched': 'bool',
        'is_hidden': 'bool',
        'is_blank': 'bool'
    }

    attribute_map = {
        'link': 'link',
        'index': 'Index',
        'style': 'Style',
        'group_level': 'GroupLevel',
        'height': 'Height',
        'is_height_matched': 'IsHeightMatched',
        'is_hidden': 'IsHidden',
        'is_blank': 'IsBlank'
    }
    
    @staticmethod
    def get_swagger_types():
        return Row.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Row.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, index=None, style=None, group_level=None, height=None, is_height_matched=None, is_hidden=None, is_blank=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Row - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['index'] = None
        self.container['style'] = None
        self.container['group_level'] = None
        self.container['height'] = None
        self.container['is_height_matched'] = None
        self.container['is_hidden'] = None
        self.container['is_blank'] = None

        if link is not None:
          self.link = link
        if index is not None:
          self.index = index
        if style is not None:
          self.style = style
        if group_level is not None:
          self.group_level = group_level
        if height is not None:
          self.height = height
        if is_height_matched is not None:
          self.is_height_matched = is_height_matched
        if is_hidden is not None:
          self.is_hidden = is_hidden
        if is_blank is not None:
          self.is_blank = is_blank

    @property
    def link(self):
        """
        Gets the link of this Row.

        :return: The link of this Row.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this Row.

        :param link: The link of this Row.
        :type: Link
        """

        self.container['link'] = link

    @property
    def index(self):
        """
        Gets the index of this Row.

        :return: The index of this Row.
        :rtype: int
        """
        return self.container['index']

    @index.setter
    def index(self, index):
        """
        Sets the index of this Row.

        :param index: The index of this Row.
        :type: int
        """

        self.container['index'] = index

    @property
    def style(self):
        """
        Gets the style of this Row.

        :return: The style of this Row.
        :rtype: LinkElement
        """
        return self.container['style']

    @style.setter
    def style(self, style):
        """
        Sets the style of this Row.

        :param style: The style of this Row.
        :type: LinkElement
        """

        self.container['style'] = style

    @property
    def group_level(self):
        """
        Gets the group_level of this Row.

        :return: The group_level of this Row.
        :rtype: int
        """
        return self.container['group_level']

    @group_level.setter
    def group_level(self, group_level):
        """
        Sets the group_level of this Row.

        :param group_level: The group_level of this Row.
        :type: int
        """

        self.container['group_level'] = group_level

    @property
    def height(self):
        """
        Gets the height of this Row.

        :return: The height of this Row.
        :rtype: float
        """
        return self.container['height']

    @height.setter
    def height(self, height):
        """
        Sets the height of this Row.

        :param height: The height of this Row.
        :type: float
        """

        self.container['height'] = height

    @property
    def is_height_matched(self):
        """
        Gets the is_height_matched of this Row.

        :return: The is_height_matched of this Row.
        :rtype: bool
        """
        return self.container['is_height_matched']

    @is_height_matched.setter
    def is_height_matched(self, is_height_matched):
        """
        Sets the is_height_matched of this Row.

        :param is_height_matched: The is_height_matched of this Row.
        :type: bool
        """

        self.container['is_height_matched'] = is_height_matched

    @property
    def is_hidden(self):
        """
        Gets the is_hidden of this Row.

        :return: The is_hidden of this Row.
        :rtype: bool
        """
        return self.container['is_hidden']

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        """
        Sets the is_hidden of this Row.

        :param is_hidden: The is_hidden of this Row.
        :type: bool
        """

        self.container['is_hidden'] = is_hidden

    @property
    def is_blank(self):
        """
        Gets the is_blank of this Row.

        :return: The is_blank of this Row.
        :rtype: bool
        """
        return self.container['is_blank']

    @is_blank.setter
    def is_blank(self, is_blank):
        """
        Sets the is_blank of this Row.

        :param is_blank: The is_blank of this Row.
        :type: bool
        """

        self.container['is_blank'] = is_blank

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Row):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
