# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class NegativeBarFormat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'border_color': 'Color',
        'color': 'Color',
        'border_color_type': 'str',
        'color_type': 'str'
    }

    attribute_map = {
        'border_color': 'BorderColor',
        'color': 'Color',
        'border_color_type': 'BorderColorType',
        'color_type': 'ColorType'
    }
    
    @staticmethod
    def get_swagger_types():
        return NegativeBarFormat.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return NegativeBarFormat.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, border_color=None, color=None, border_color_type=None, color_type=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        NegativeBarFormat - a model defined in Swagger
        """

        self.container['border_color'] = None
        self.container['color'] = None
        self.container['border_color_type'] = None
        self.container['color_type'] = None

        if border_color is not None:
          self.border_color = border_color
        if color is not None:
          self.color = color
        if border_color_type is not None:
          self.border_color_type = border_color_type
        if color_type is not None:
          self.color_type = color_type

    @property
    def border_color(self):
        """
        Gets the border_color of this NegativeBarFormat.
        Gets or sets a FormatColor object that you can use to specify the border    color for negative data bars.             

        :return: The border_color of this NegativeBarFormat.
        :rtype: Color
        """
        return self.container['border_color']

    @border_color.setter
    def border_color(self, border_color):
        """
        Sets the border_color of this NegativeBarFormat.
        Gets or sets a FormatColor object that you can use to specify the border    color for negative data bars.             

        :param border_color: The border_color of this NegativeBarFormat.
        :type: Color
        """

        self.container['border_color'] = border_color

    @property
    def color(self):
        """
        Gets the color of this NegativeBarFormat.
        Gets or sets a FormatColor object that you can use to specify the fill color    for negative data bars.             

        :return: The color of this NegativeBarFormat.
        :rtype: Color
        """
        return self.container['color']

    @color.setter
    def color(self, color):
        """
        Sets the color of this NegativeBarFormat.
        Gets or sets a FormatColor object that you can use to specify the fill color    for negative data bars.             

        :param color: The color of this NegativeBarFormat.
        :type: Color
        """

        self.container['color'] = color

    @property
    def border_color_type(self):
        """
        Gets the border_color_type of this NegativeBarFormat.
        Gets whether to use the same border color as positive data bars.             

        :return: The border_color_type of this NegativeBarFormat.
        :rtype: str
        """
        return self.container['border_color_type']

    @border_color_type.setter
    def border_color_type(self, border_color_type):
        """
        Sets the border_color_type of this NegativeBarFormat.
        Gets whether to use the same border color as positive data bars.             

        :param border_color_type: The border_color_type of this NegativeBarFormat.
        :type: str
        """

        self.container['border_color_type'] = border_color_type

    @property
    def color_type(self):
        """
        Gets the color_type of this NegativeBarFormat.
        Gets or sets whether to use the same fill color as positive data bars.

        :return: The color_type of this NegativeBarFormat.
        :rtype: str
        """
        return self.container['color_type']

    @color_type.setter
    def color_type(self, color_type):
        """
        Sets the color_type of this NegativeBarFormat.
        Gets or sets whether to use the same fill color as positive data bars.

        :param color_type: The color_type of this NegativeBarFormat.
        :type: str
        """

        self.container['color_type'] = color_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NegativeBarFormat):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
