# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import SaveOptions

class MarkdownSaveOptions(SaveOptions):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'encoding': 'str',
        'format_strategy': 'str',
        'line_separator': 'str'
    }

    attribute_map = {
        'encoding': 'Encoding',
        'format_strategy': 'FormatStrategy',
        'line_separator': 'LineSeparator'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(MarkdownSaveOptions.swagger_types, **SaveOptions.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(MarkdownSaveOptions.attribute_map, **SaveOptions.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, encoding=None, format_strategy=None, line_separator=None, **kw):
        super(MarkdownSaveOptions, self).__init__(**kw)
		    
        """
        MarkdownSaveOptions - a model defined in Swagger
        """

        self.container['encoding'] = None
        self.container['format_strategy'] = None
        self.container['line_separator'] = None

        if encoding is not None:
          self.encoding = encoding
        if format_strategy is not None:
          self.format_strategy = format_strategy
        if line_separator is not None:
          self.line_separator = line_separator

    @property
    def encoding(self):
        """
        Gets the encoding of this MarkdownSaveOptions.

        :return: The encoding of this MarkdownSaveOptions.
        :rtype: str
        """
        return self.container['encoding']

    @encoding.setter
    def encoding(self, encoding):
        """
        Sets the encoding of this MarkdownSaveOptions.

        :param encoding: The encoding of this MarkdownSaveOptions.
        :type: str
        """

        self.container['encoding'] = encoding

    @property
    def format_strategy(self):
        """
        Gets the format_strategy of this MarkdownSaveOptions.

        :return: The format_strategy of this MarkdownSaveOptions.
        :rtype: str
        """
        return self.container['format_strategy']

    @format_strategy.setter
    def format_strategy(self, format_strategy):
        """
        Sets the format_strategy of this MarkdownSaveOptions.

        :param format_strategy: The format_strategy of this MarkdownSaveOptions.
        :type: str
        """

        self.container['format_strategy'] = format_strategy

    @property
    def line_separator(self):
        """
        Gets the line_separator of this MarkdownSaveOptions.

        :return: The line_separator of this MarkdownSaveOptions.
        :rtype: str
        """
        return self.container['line_separator']

    @line_separator.setter
    def line_separator(self, line_separator):
        """
        Sets the line_separator of this MarkdownSaveOptions.

        :param line_separator: The line_separator of this MarkdownSaveOptions.
        :type: str
        """

        self.container['line_separator'] = line_separator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MarkdownSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
