# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class LineFormat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'texture_fill': 'TextureFill',
        'image_data': 'str',
        'pattern_fill': 'PatternFill',
        'solid_fill': 'SolidFill',
        'gradient_fill': 'GradientFill',
        'type': 'str',
        'begin_arrowhead_length': 'str',
        'dash_style': 'str',
        'end_arrowhead_width': 'str',
        'end_arrowhead_length': 'str',
        'begin_arrowhead_width': 'str',
        'compound_type': 'str',
        'join_type': 'str',
        'weight': 'float',
        'begin_arrowhead_style': 'str',
        'end_arrowhead_style': 'str',
        'cap_type': 'str'
    }

    attribute_map = {
        'texture_fill': 'TextureFill',
        'image_data': 'ImageData',
        'pattern_fill': 'PatternFill',
        'solid_fill': 'SolidFill',
        'gradient_fill': 'GradientFill',
        'type': 'Type',
        'begin_arrowhead_length': 'BeginArrowheadLength',
        'dash_style': 'DashStyle',
        'end_arrowhead_width': 'EndArrowheadWidth',
        'end_arrowhead_length': 'EndArrowheadLength',
        'begin_arrowhead_width': 'BeginArrowheadWidth',
        'compound_type': 'CompoundType',
        'join_type': 'JoinType',
        'weight': 'Weight',
        'begin_arrowhead_style': 'BeginArrowheadStyle',
        'end_arrowhead_style': 'EndArrowheadStyle',
        'cap_type': 'CapType'
    }
    
    @staticmethod
    def get_swagger_types():
        return LineFormat.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return LineFormat.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, texture_fill=None, image_data=None, pattern_fill=None, solid_fill=None, gradient_fill=None, type=None, begin_arrowhead_length=None, dash_style=None, end_arrowhead_width=None, end_arrowhead_length=None, begin_arrowhead_width=None, compound_type=None, join_type=None, weight=None, begin_arrowhead_style=None, end_arrowhead_style=None, cap_type=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        LineFormat - a model defined in Swagger
        """

        self.container['texture_fill'] = None
        self.container['image_data'] = None
        self.container['pattern_fill'] = None
        self.container['solid_fill'] = None
        self.container['gradient_fill'] = None
        self.container['type'] = None
        self.container['begin_arrowhead_length'] = None
        self.container['dash_style'] = None
        self.container['end_arrowhead_width'] = None
        self.container['end_arrowhead_length'] = None
        self.container['begin_arrowhead_width'] = None
        self.container['compound_type'] = None
        self.container['join_type'] = None
        self.container['weight'] = None
        self.container['begin_arrowhead_style'] = None
        self.container['end_arrowhead_style'] = None
        self.container['cap_type'] = None

        if texture_fill is not None:
          self.texture_fill = texture_fill
        if image_data is not None:
          self.image_data = image_data
        if pattern_fill is not None:
          self.pattern_fill = pattern_fill
        if solid_fill is not None:
          self.solid_fill = solid_fill
        if gradient_fill is not None:
          self.gradient_fill = gradient_fill
        if type is not None:
          self.type = type
        if begin_arrowhead_length is not None:
          self.begin_arrowhead_length = begin_arrowhead_length
        if dash_style is not None:
          self.dash_style = dash_style
        if end_arrowhead_width is not None:
          self.end_arrowhead_width = end_arrowhead_width
        if end_arrowhead_length is not None:
          self.end_arrowhead_length = end_arrowhead_length
        if begin_arrowhead_width is not None:
          self.begin_arrowhead_width = begin_arrowhead_width
        if compound_type is not None:
          self.compound_type = compound_type
        if join_type is not None:
          self.join_type = join_type
        if weight is not None:
          self.weight = weight
        if begin_arrowhead_style is not None:
          self.begin_arrowhead_style = begin_arrowhead_style
        if end_arrowhead_style is not None:
          self.end_arrowhead_style = end_arrowhead_style
        if cap_type is not None:
          self.cap_type = cap_type

    @property
    def texture_fill(self):
        """
        Gets the texture_fill of this LineFormat.

        :return: The texture_fill of this LineFormat.
        :rtype: TextureFill
        """
        return self.container['texture_fill']

    @texture_fill.setter
    def texture_fill(self, texture_fill):
        """
        Sets the texture_fill of this LineFormat.

        :param texture_fill: The texture_fill of this LineFormat.
        :type: TextureFill
        """

        self.container['texture_fill'] = texture_fill

    @property
    def image_data(self):
        """
        Gets the image_data of this LineFormat.

        :return: The image_data of this LineFormat.
        :rtype: str
        """
        return self.container['image_data']

    @image_data.setter
    def image_data(self, image_data):
        """
        Sets the image_data of this LineFormat.

        :param image_data: The image_data of this LineFormat.
        :type: str
        """
        if image_data is not None and not re.search('^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', image_data):
            raise ValueError("Invalid value for `image_data`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")

        self.container['image_data'] = image_data

    @property
    def pattern_fill(self):
        """
        Gets the pattern_fill of this LineFormat.

        :return: The pattern_fill of this LineFormat.
        :rtype: PatternFill
        """
        return self.container['pattern_fill']

    @pattern_fill.setter
    def pattern_fill(self, pattern_fill):
        """
        Sets the pattern_fill of this LineFormat.

        :param pattern_fill: The pattern_fill of this LineFormat.
        :type: PatternFill
        """

        self.container['pattern_fill'] = pattern_fill

    @property
    def solid_fill(self):
        """
        Gets the solid_fill of this LineFormat.

        :return: The solid_fill of this LineFormat.
        :rtype: SolidFill
        """
        return self.container['solid_fill']

    @solid_fill.setter
    def solid_fill(self, solid_fill):
        """
        Sets the solid_fill of this LineFormat.

        :param solid_fill: The solid_fill of this LineFormat.
        :type: SolidFill
        """

        self.container['solid_fill'] = solid_fill

    @property
    def gradient_fill(self):
        """
        Gets the gradient_fill of this LineFormat.

        :return: The gradient_fill of this LineFormat.
        :rtype: GradientFill
        """
        return self.container['gradient_fill']

    @gradient_fill.setter
    def gradient_fill(self, gradient_fill):
        """
        Sets the gradient_fill of this LineFormat.

        :param gradient_fill: The gradient_fill of this LineFormat.
        :type: GradientFill
        """

        self.container['gradient_fill'] = gradient_fill

    @property
    def type(self):
        """
        Gets the type of this LineFormat.

        :return: The type of this LineFormat.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this LineFormat.

        :param type: The type of this LineFormat.
        :type: str
        """

        self.container['type'] = type

    @property
    def begin_arrowhead_length(self):
        """
        Gets the begin_arrowhead_length of this LineFormat.

        :return: The begin_arrowhead_length of this LineFormat.
        :rtype: str
        """
        return self.container['begin_arrowhead_length']

    @begin_arrowhead_length.setter
    def begin_arrowhead_length(self, begin_arrowhead_length):
        """
        Sets the begin_arrowhead_length of this LineFormat.

        :param begin_arrowhead_length: The begin_arrowhead_length of this LineFormat.
        :type: str
        """

        self.container['begin_arrowhead_length'] = begin_arrowhead_length

    @property
    def dash_style(self):
        """
        Gets the dash_style of this LineFormat.

        :return: The dash_style of this LineFormat.
        :rtype: str
        """
        return self.container['dash_style']

    @dash_style.setter
    def dash_style(self, dash_style):
        """
        Sets the dash_style of this LineFormat.

        :param dash_style: The dash_style of this LineFormat.
        :type: str
        """

        self.container['dash_style'] = dash_style

    @property
    def end_arrowhead_width(self):
        """
        Gets the end_arrowhead_width of this LineFormat.

        :return: The end_arrowhead_width of this LineFormat.
        :rtype: str
        """
        return self.container['end_arrowhead_width']

    @end_arrowhead_width.setter
    def end_arrowhead_width(self, end_arrowhead_width):
        """
        Sets the end_arrowhead_width of this LineFormat.

        :param end_arrowhead_width: The end_arrowhead_width of this LineFormat.
        :type: str
        """

        self.container['end_arrowhead_width'] = end_arrowhead_width

    @property
    def end_arrowhead_length(self):
        """
        Gets the end_arrowhead_length of this LineFormat.

        :return: The end_arrowhead_length of this LineFormat.
        :rtype: str
        """
        return self.container['end_arrowhead_length']

    @end_arrowhead_length.setter
    def end_arrowhead_length(self, end_arrowhead_length):
        """
        Sets the end_arrowhead_length of this LineFormat.

        :param end_arrowhead_length: The end_arrowhead_length of this LineFormat.
        :type: str
        """

        self.container['end_arrowhead_length'] = end_arrowhead_length

    @property
    def begin_arrowhead_width(self):
        """
        Gets the begin_arrowhead_width of this LineFormat.

        :return: The begin_arrowhead_width of this LineFormat.
        :rtype: str
        """
        return self.container['begin_arrowhead_width']

    @begin_arrowhead_width.setter
    def begin_arrowhead_width(self, begin_arrowhead_width):
        """
        Sets the begin_arrowhead_width of this LineFormat.

        :param begin_arrowhead_width: The begin_arrowhead_width of this LineFormat.
        :type: str
        """

        self.container['begin_arrowhead_width'] = begin_arrowhead_width

    @property
    def compound_type(self):
        """
        Gets the compound_type of this LineFormat.

        :return: The compound_type of this LineFormat.
        :rtype: str
        """
        return self.container['compound_type']

    @compound_type.setter
    def compound_type(self, compound_type):
        """
        Sets the compound_type of this LineFormat.

        :param compound_type: The compound_type of this LineFormat.
        :type: str
        """

        self.container['compound_type'] = compound_type

    @property
    def join_type(self):
        """
        Gets the join_type of this LineFormat.

        :return: The join_type of this LineFormat.
        :rtype: str
        """
        return self.container['join_type']

    @join_type.setter
    def join_type(self, join_type):
        """
        Sets the join_type of this LineFormat.

        :param join_type: The join_type of this LineFormat.
        :type: str
        """

        self.container['join_type'] = join_type

    @property
    def weight(self):
        """
        Gets the weight of this LineFormat.

        :return: The weight of this LineFormat.
        :rtype: float
        """
        return self.container['weight']

    @weight.setter
    def weight(self, weight):
        """
        Sets the weight of this LineFormat.

        :param weight: The weight of this LineFormat.
        :type: float
        """

        self.container['weight'] = weight

    @property
    def begin_arrowhead_style(self):
        """
        Gets the begin_arrowhead_style of this LineFormat.

        :return: The begin_arrowhead_style of this LineFormat.
        :rtype: str
        """
        return self.container['begin_arrowhead_style']

    @begin_arrowhead_style.setter
    def begin_arrowhead_style(self, begin_arrowhead_style):
        """
        Sets the begin_arrowhead_style of this LineFormat.

        :param begin_arrowhead_style: The begin_arrowhead_style of this LineFormat.
        :type: str
        """

        self.container['begin_arrowhead_style'] = begin_arrowhead_style

    @property
    def end_arrowhead_style(self):
        """
        Gets the end_arrowhead_style of this LineFormat.

        :return: The end_arrowhead_style of this LineFormat.
        :rtype: str
        """
        return self.container['end_arrowhead_style']

    @end_arrowhead_style.setter
    def end_arrowhead_style(self, end_arrowhead_style):
        """
        Sets the end_arrowhead_style of this LineFormat.

        :param end_arrowhead_style: The end_arrowhead_style of this LineFormat.
        :type: str
        """

        self.container['end_arrowhead_style'] = end_arrowhead_style

    @property
    def cap_type(self):
        """
        Gets the cap_type of this LineFormat.

        :return: The cap_type of this LineFormat.
        :rtype: str
        """
        return self.container['cap_type']

    @cap_type.setter
    def cap_type(self, cap_type):
        """
        Sets the cap_type of this LineFormat.

        :param cap_type: The cap_type of this LineFormat.
        :type: str
        """

        self.container['cap_type'] = cap_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LineFormat):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
