# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import ImportOption

class ImportCSVDataOption(ImportOption):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'convert_numeric_data': 'bool',
        'first_column': 'int',
        'source_file': 'str',
        'first_row': 'int',
        'separator_string': 'str',
        'custom_parsers': 'list[CustomParserConfig]'
    }

    attribute_map = {
        'convert_numeric_data': 'ConvertNumericData',
        'first_column': 'FirstColumn',
        'source_file': 'SourceFile',
        'first_row': 'FirstRow',
        'separator_string': 'SeparatorString',
        'custom_parsers': 'CustomParsers'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(ImportCSVDataOption.swagger_types, **ImportOption.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(ImportCSVDataOption.attribute_map, **ImportOption.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, convert_numeric_data=None, first_column=None, source_file=None, first_row=None, separator_string=None, custom_parsers=None, **kw):
        super(ImportCSVDataOption, self).__init__(**kw)
		    
        """
        ImportCSVDataOption - a model defined in Swagger
        """

        self.container['convert_numeric_data'] = None
        self.container['first_column'] = None
        self.container['source_file'] = None
        self.container['first_row'] = None
        self.container['separator_string'] = None
        self.container['custom_parsers'] = None

        if convert_numeric_data is not None:
          self.convert_numeric_data = convert_numeric_data
        if first_column is not None:
          self.first_column = first_column
        if source_file is not None:
          self.source_file = source_file
        if first_row is not None:
          self.first_row = first_row
        if separator_string is not None:
          self.separator_string = separator_string
        if custom_parsers is not None:
          self.custom_parsers = custom_parsers

    @property
    def convert_numeric_data(self):
        """
        Gets the convert_numeric_data of this ImportCSVDataOption.

        :return: The convert_numeric_data of this ImportCSVDataOption.
        :rtype: bool
        """
        return self.container['convert_numeric_data']

    @convert_numeric_data.setter
    def convert_numeric_data(self, convert_numeric_data):
        """
        Sets the convert_numeric_data of this ImportCSVDataOption.

        :param convert_numeric_data: The convert_numeric_data of this ImportCSVDataOption.
        :type: bool
        """

        self.container['convert_numeric_data'] = convert_numeric_data

    @property
    def first_column(self):
        """
        Gets the first_column of this ImportCSVDataOption.

        :return: The first_column of this ImportCSVDataOption.
        :rtype: int
        """
        return self.container['first_column']

    @first_column.setter
    def first_column(self, first_column):
        """
        Sets the first_column of this ImportCSVDataOption.

        :param first_column: The first_column of this ImportCSVDataOption.
        :type: int
        """

        self.container['first_column'] = first_column

    @property
    def source_file(self):
        """
        Gets the source_file of this ImportCSVDataOption.

        :return: The source_file of this ImportCSVDataOption.
        :rtype: str
        """
        return self.container['source_file']

    @source_file.setter
    def source_file(self, source_file):
        """
        Sets the source_file of this ImportCSVDataOption.

        :param source_file: The source_file of this ImportCSVDataOption.
        :type: str
        """

        self.container['source_file'] = source_file

    @property
    def first_row(self):
        """
        Gets the first_row of this ImportCSVDataOption.

        :return: The first_row of this ImportCSVDataOption.
        :rtype: int
        """
        return self.container['first_row']

    @first_row.setter
    def first_row(self, first_row):
        """
        Sets the first_row of this ImportCSVDataOption.

        :param first_row: The first_row of this ImportCSVDataOption.
        :type: int
        """

        self.container['first_row'] = first_row

    @property
    def separator_string(self):
        """
        Gets the separator_string of this ImportCSVDataOption.

        :return: The separator_string of this ImportCSVDataOption.
        :rtype: str
        """
        return self.container['separator_string']

    @separator_string.setter
    def separator_string(self, separator_string):
        """
        Sets the separator_string of this ImportCSVDataOption.

        :param separator_string: The separator_string of this ImportCSVDataOption.
        :type: str
        """

        self.container['separator_string'] = separator_string

    @property
    def custom_parsers(self):
        """
        Gets the custom_parsers of this ImportCSVDataOption.

        :return: The custom_parsers of this ImportCSVDataOption.
        :rtype: list[CustomParserConfig]
        """
        return self.container['custom_parsers']

    @custom_parsers.setter
    def custom_parsers(self, custom_parsers):
        """
        Sets the custom_parsers of this ImportCSVDataOption.

        :param custom_parsers: The custom_parsers of this ImportCSVDataOption.
        :type: list[CustomParserConfig]
        """

        self.container['custom_parsers'] = custom_parsers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ImportCSVDataOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
