# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class FontSetting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'text_options': 'TextOptions',
        'length': 'int',
        'font': 'Font',
        'type': 'str',
        'start_index': 'int'
    }

    attribute_map = {
        'text_options': 'TextOptions',
        'length': 'Length',
        'font': 'Font',
        'type': 'Type',
        'start_index': 'StartIndex'
    }
    
    @staticmethod
    def get_swagger_types():
        return FontSetting.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return FontSetting.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, text_options=None, length=None, font=None, type=None, start_index=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        FontSetting - a model defined in Swagger
        """

        self.container['text_options'] = None
        self.container['length'] = None
        self.container['font'] = None
        self.container['type'] = None
        self.container['start_index'] = None

        if text_options is not None:
          self.text_options = text_options
        self.length = length
        if font is not None:
          self.font = font
        if type is not None:
          self.type = type
        self.start_index = start_index

    @property
    def text_options(self):
        """
        Gets the text_options of this FontSetting.

        :return: The text_options of this FontSetting.
        :rtype: TextOptions
        """
        return self.container['text_options']

    @text_options.setter
    def text_options(self, text_options):
        """
        Sets the text_options of this FontSetting.

        :param text_options: The text_options of this FontSetting.
        :type: TextOptions
        """

        self.container['text_options'] = text_options

    @property
    def length(self):
        """
        Gets the length of this FontSetting.

        :return: The length of this FontSetting.
        :rtype: int
        """
        return self.container['length']

    @length.setter
    def length(self, length):
        """
        Sets the length of this FontSetting.

        :param length: The length of this FontSetting.
        :type: int
        """
        """
        if length is None:
            raise ValueError("Invalid value for `length`, must not be `None`")
        """

        self.container['length'] = length

    @property
    def font(self):
        """
        Gets the font of this FontSetting.

        :return: The font of this FontSetting.
        :rtype: Font
        """
        return self.container['font']

    @font.setter
    def font(self, font):
        """
        Sets the font of this FontSetting.

        :param font: The font of this FontSetting.
        :type: Font
        """

        self.container['font'] = font

    @property
    def type(self):
        """
        Gets the type of this FontSetting.

        :return: The type of this FontSetting.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this FontSetting.

        :param type: The type of this FontSetting.
        :type: str
        """

        self.container['type'] = type

    @property
    def start_index(self):
        """
        Gets the start_index of this FontSetting.

        :return: The start_index of this FontSetting.
        :rtype: int
        """
        return self.container['start_index']

    @start_index.setter
    def start_index(self, start_index):
        """
        Sets the start_index of this FontSetting.

        :param start_index: The start_index of this FontSetting.
        :type: int
        """
        """
        if start_index is None:
            raise ValueError("Invalid value for `start_index`, must not be `None`")
        """

        self.container['start_index'] = start_index

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FontSetting):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
