# coding: utf-8

"""
Copyright (c) 2021 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class FileInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'filename': 'str',
        'file_size': 'int',
        'file_content': 'str'
    }

    attribute_map = {
        'filename': 'Filename',
        'file_size': 'FileSize',
        'file_content': 'FileContent'
    }
    
    @staticmethod
    def get_swagger_types():
        return FileInfo.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return FileInfo.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, filename=None, file_size=None, file_content=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        FileInfo - a model defined in Swagger
        """

        self.container['filename'] = None
        self.container['file_size'] = None
        self.container['file_content'] = None

        if filename is not None:
          self.filename = filename
        self.file_size = file_size
        if file_content is not None:
          self.file_content = file_content

    @property
    def filename(self):
        """
        Gets the filename of this FileInfo.

        :return: The filename of this FileInfo.
        :rtype: str
        """
        return self.container['filename']

    @filename.setter
    def filename(self, filename):
        """
        Sets the filename of this FileInfo.

        :param filename: The filename of this FileInfo.
        :type: str
        """

        self.container['filename'] = filename

    @property
    def file_size(self):
        """
        Gets the file_size of this FileInfo.

        :return: The file_size of this FileInfo.
        :rtype: int
        """
        return self.container['file_size']

    @file_size.setter
    def file_size(self, file_size):
        """
        Sets the file_size of this FileInfo.

        :param file_size: The file_size of this FileInfo.
        :type: int
        """
        """
        if file_size is None:
            raise ValueError("Invalid value for `file_size`, must not be `None`")
        """

        self.container['file_size'] = file_size

    @property
    def file_content(self):
        """
        Gets the file_content of this FileInfo.

        :return: The file_content of this FileInfo.
        :rtype: str
        """
        return self.container['file_content']

    @file_content.setter
    def file_content(self, file_content):
        """
        Sets the file_content of this FileInfo.

        :param file_content: The file_content of this FileInfo.
        :type: str
        """

        self.container['file_content'] = file_content

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FileInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
