# coding: utf-8

"""
Copyright (c) 2022 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class CellsDocumentProperty(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'name': 'str',
        'value': 'str',
        'is_linked_to_content': 'str',
        'source': 'str',
        'type': 'str',
        'is_generated_name': 'str'
    }

    attribute_map = {
        'link': 'link',
        'name': 'Name',
        'value': 'Value',
        'is_linked_to_content': 'IsLinkedToContent',
        'source': 'Source',
        'type': 'Type',
        'is_generated_name': 'IsGeneratedName'
    }
    
    @staticmethod
    def get_swagger_types():
        return CellsDocumentProperty.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return CellsDocumentProperty.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, name=None, value=None, is_linked_to_content=None, source=None, type=None, is_generated_name=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        CellsDocumentProperty - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['name'] = None
        self.container['value'] = None
        self.container['is_linked_to_content'] = None
        self.container['source'] = None
        self.container['type'] = None
        self.container['is_generated_name'] = None

        if link is not None:
          self.link = link
        if name is not None:
          self.name = name
        if value is not None:
          self.value = value
        if is_linked_to_content is not None:
          self.is_linked_to_content = is_linked_to_content
        if source is not None:
          self.source = source
        if type is not None:
          self.type = type
        if is_generated_name is not None:
          self.is_generated_name = is_generated_name

    @property
    def link(self):
        """
        Gets the link of this CellsDocumentProperty.

        :return: The link of this CellsDocumentProperty.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this CellsDocumentProperty.

        :param link: The link of this CellsDocumentProperty.
        :type: Link
        """

        self.container['link'] = link

    @property
    def name(self):
        """
        Gets the name of this CellsDocumentProperty.
        Returns the name of the property.             

        :return: The name of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['name']

    @name.setter
    def name(self, name):
        """
        Sets the name of this CellsDocumentProperty.
        Returns the name of the property.             

        :param name: The name of this CellsDocumentProperty.
        :type: str
        """

        self.container['name'] = name

    @property
    def value(self):
        """
        Gets the value of this CellsDocumentProperty.
        Gets or sets the value of the property.

        :return: The value of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['value']

    @value.setter
    def value(self, value):
        """
        Sets the value of this CellsDocumentProperty.
        Gets or sets the value of the property.

        :param value: The value of this CellsDocumentProperty.
        :type: str
        """

        self.container['value'] = value

    @property
    def is_linked_to_content(self):
        """
        Gets the is_linked_to_content of this CellsDocumentProperty.
        Indicates whether this property is linked to content

        :return: The is_linked_to_content of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['is_linked_to_content']

    @is_linked_to_content.setter
    def is_linked_to_content(self, is_linked_to_content):
        """
        Sets the is_linked_to_content of this CellsDocumentProperty.
        Indicates whether this property is linked to content

        :param is_linked_to_content: The is_linked_to_content of this CellsDocumentProperty.
        :type: str
        """

        self.container['is_linked_to_content'] = is_linked_to_content

    @property
    def source(self):
        """
        Gets the source of this CellsDocumentProperty.
        The linked content source.

        :return: The source of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['source']

    @source.setter
    def source(self, source):
        """
        Sets the source of this CellsDocumentProperty.
        The linked content source.

        :param source: The source of this CellsDocumentProperty.
        :type: str
        """

        self.container['source'] = source

    @property
    def type(self):
        """
        Gets the type of this CellsDocumentProperty.
        Gets the data type of the property.             

        :return: The type of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this CellsDocumentProperty.
        Gets the data type of the property.             

        :param type: The type of this CellsDocumentProperty.
        :type: str
        """

        self.container['type'] = type

    @property
    def is_generated_name(self):
        """
        Gets the is_generated_name of this CellsDocumentProperty.
        Returns true if this property does not have a name in the OLE2 storage and a   unique name was generated only for the public API.             

        :return: The is_generated_name of this CellsDocumentProperty.
        :rtype: str
        """
        return self.container['is_generated_name']

    @is_generated_name.setter
    def is_generated_name(self, is_generated_name):
        """
        Sets the is_generated_name of this CellsDocumentProperty.
        Returns true if this property does not have a name in the OLE2 storage and a   unique name was generated only for the public API.             

        :param is_generated_name: The is_generated_name of this CellsDocumentProperty.
        :type: str
        """

        self.container['is_generated_name'] = is_generated_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CellsDocumentProperty):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
