from random import choice
from rich.console import Console

console = Console()

word_list = ['слово', 'людина', 'час', 'справа', 'життя', 'день', 'рука', 'робота', 'місце', 'обличчя',
             'друг', 'питання', 'будинок', 'сторона', 'країна', 'світ', 'випадок', 'голова', 'дитина', 'сила',
             'кінець', 'система', 'частина', 'місто', 'ставлення', 'жінка', 'гроші', 'земля', 'машина', 'вода',
             'батько', 'проблема', 'година', 'право', 'нога', 'рішення', 'двері', 'образ', 'історія', 'влада', 'закон',
             'війна', 'бог', 'голос', 'тисяча', 'книга', 'можливість', 'результат', 'ніч', 'стіл', 'область',
             'стаття', 'число', 'компанія', 'народ', 'дружина', 'група', 'розвиток', 'процес', 'суд', 'умова',
             'засіб', 'початок', 'світло', 'час', 'шлях', 'душа', 'рівень', 'форма', "зв'язок", 'хвилина',
             'вулиця', 'вечір', 'якість', 'ідея', 'дорога', 'мати', 'дія', 'місяць', 'держава', 'мова', 'любов',
             'погляд', 'мама', 'століття', 'школа', 'ціль', 'суспільство', 'діяльність', 'організація', 'президент',
             'кімната', 'порядок', 'момент', 'театр', 'лист', 'ранок', 'допомога', 'ситуація', 'роль', 'рубль', 'сенс',
             'стан', 'квартира', 'орган', 'увага', 'тіло', 'праця', 'син', 'міра', 'смерть', 'ринок ', 'програма',
             'завдання', 'підприємство', 'вікно', 'розмова', 'уряд', 'виробництво', 'інформація', 'становище',
             'центр', 'відповідь', 'чоловік', 'автор', 'стіна', 'інтерес', 'федерація', 'правило', 'управління',
             'чоловік', 'ідея', 'партія', 'рада', 'рахунок', 'серце ', 'рух', 'матеріал', 'тиждень', 'почуття',
             'глава', 'наука', 'ряд', 'газета', 'причина', 'ціна', 'план', 'мова', 'точка', 'основа',
             'товариш', 'культура', 'думка', 'документ', 'інститут', 'хід', 'проект', 'зустріч', 'директор',
             'термін', 'палець', 'досвід', 'служба', 'доля', 'дівчина', 'черга', 'ліс', 'склад', 'кількість',
             "подія", "зал", "створення", "значення", "період", "крок", "брат", "мистецтво", "структура",
             "номер", "приклад", "дослідження", 'громадянин', 'гра', 'начальник', 'зріст', 'тема', 'принцип', 'метод',
             'фільм', 'краївка', 'гість', 'повітря', 'характер', 'боротьба', 'використання', 'розмір', 'освіта',
             'хлопчик', 'небо', 'армія', 'клас', 'представник', 'участь', 'дівчинка', 'політика',
             'герой', 'картина', 'долар', 'спина', 'територія', 'поле', 'зміна', 'напрямок', 'малюнок', 'течія',
             'церква', 'банк', 'сцена', 'населення', 'більшість', 'музика', 'правда', 'свобода', 'команда',
             'союз', 'лікар', 'договір', 'дерево', 'факт', 'господар', 'природа', 'телефон', 'позиція', 'двір',
             'письменник', 'літак', 'обсяг', 'рід', 'сонце', 'віра', 'берег', 'вистава', 'фірма', 'завод',
             'колір', 'журнал', 'керівник', 'фахівець', 'оцінка', 'регіон', 'пісня', 'відсоток', 'батько', 'море',
             'вимоги', 'основа', 'половина', 'роман', 'коло', 'аналіз ', 'вірші', 'автомобіль', 'економіка',
             'література', 'папір', 'поет', 'ступень', 'пан', 'надія', 'предмет', 'варіант', 'міністр', 'кордон',
             'дух', 'модель', 'операція', 'пара', 'сон', 'назва', 'розум', 'привід', 'старий', 'мільйон', 'успіх',
             'щастя', 'хлопці', 'кабінет', 'магазин', 'простір', 'вихід', 'удар', 'база', 'знання', 'текст', 'захист',
             'керівництво', 'площа', 'свідомість', 'вік', 'учасник', 'дільниця', 'пункт', 'лінія', 'бажання', 'тато',
             'лікар', 'губа', 'дочка', 'середовище', 'голова', 'подання', 'солдат', 'художник', 'зброя',
             'відповідність', 'вітер', 'хлопець', 'зір', 'генерал', 'вогонь', 'поняття', 'будівництво', 'вухо',
             'груди', 'ніс', 'страх', 'послуга', 'зміст', 'радість', 'безпека', 'продукт', 'комплекс', 'бізнес', 'сад',
             'співробітник', 'літо', 'курс', 'пропозиція', 'рот', 'технологія', 'реформа', 'відсутність', 'собака',
             'камінь', 'майбутнє', 'оповідання', 'контроль', 'річка', 'продукція', 'сума', 'техніка', 'будівля',
             'сфера', 'необхідність', 'фонд', 'підготовка', 'лист', 'республіка', 'господарство', 'воля', 'бюджет',
             'сніг', 'село', 'елемент', 'обставина', 'німець', 'перемога', 'джерело', "зірка", "вибір",
             "маса", 'підсумок', 'сестра', 'практика', 'проведення', 'кишеня', 'слава', 'кухня', 'визначення',
             'функція', 'військо', 'комісія', 'застосування', 'капітан ', 'працівник', 'забезпечення', 'офіцер',
             'прізвище', 'межа', 'вибори', 'вчений', 'пляшка', 'бій', 'теорія', 'зона', 'відділ', 'зуб', 'розробка',
             'особа', 'гора', 'товар', 'метр', 'свято', 'вплив', 'читач', 'задоволення', 'актор', 'сльоза',
             'відповідальність ', 'вчитель', 'акт', 'біль', 'множина', 'особливість', 'показник', 'корабель', 'звук',
             'враження', 'приватність', 'дитинство', 'висновок', 'професор', 'частка', 'норма', 'минуле', 'командир',
             'коридор', 'підтримка', 'рамка', 'ворог', 'етап', 'чорт', 'дід', 'збори ', 'хвороба', 'клітина',
             'шкіра', 'заява', 'спроба', 'порівняння', 'розрахунок', 'депутат', 'комітет', 'знак', 'дядько', 'облік',
             'хліб', 'чай', 'режим', 'ціле', 'вірус', 'вираз', 'зима', 'десяток', 'глибина', 'мережа',
             'студент ', 'секунда', 'швидкість', 'пошук', 'сутність', 'податок', 'помилка', 'дохід']  # список слів


# Генератор рандомного слова

def get_word():
    return choice(word_list).upper()


# функція перевірка літер та заміни на "_"

def print_close_word(word_, list_):
    for c in word_:
        if c in list_:
            console.print(f"[green]{c}[/green]", end=' ')
        else:
            print('_', end=' ')
    print()


# Функція нова гра чи вихід

def game_again():
    while True:
        print(f'\nХочеш зіграти ще? так або 1/ні або 0')
        answer = input(f"{chr(10151) * 3} ")
        if answer == 'ні' or answer == "0":
            console.print("Бувай!\n[yellow]Слава Україні![/yellow]\n")
            return False
        elif answer == 'так' or answer == "1":
            return main()
        else:
            continue


def main():
    word = get_word()
    word_completion = '_ ' * len(word)  # строка, у вигляді "_" замість літер
    list_letters = []  # список названих літер
    list_words = []  # список названих слів
    count_letter = 0  # кількість правильних літер
    attempt = 6  # кількість спроб
    console.print(f"\n[yellow]H A N G M A N[/yellow]")
    console.print(f'\n[green]Ви маєте {attempt} спроб вгадати слово {display_hangman(attempt)}[/green]')
    print(f'Слово з {len(word)} літер: {word_completion}')

    while True:
        print(f'\nВведіть літеру або слово')
        user_in = input(f"{chr(10151) * 3} ").upper()
        if not user_in.isalpha():  # перевірка чи не цифра
            console.print(f"[red]Мають бути лише літери![/red]")
            continue

        if user_in == "інфо".upper():  # інформація які літери та слова називали
            console.print(f'названі літери: [green]{", ".join(list_letters)}[/green] '
                          f'\nназвані слова: [green]{", ".join(list_words)}[/green]')
            continue

        if user_in in list_words or user_in in list_letters:  # перевірка на вже названі літери та слова
            console.print(f"Ви вже [red]{user_in}[/red] називали!")
            continue

        if user_in not in word:
            attempt -= 1
            if len(user_in) == 1:
                list_letters.append(user_in)
            if len(user_in) > 1:
                list_words.append(user_in)
            console.print(f'\n[yellow]Ви маєте {attempt} спроб вгадати слово {display_hangman(attempt)}[/yellow]')
            print_close_word(word, list_letters)

        for letter in word:
            if user_in == letter:
                count_letter += 1
                if count_letter != len(word):
                    list_letters.append(user_in)
                    print_close_word(word, list_letters)
                    print(f'Ви маєте {attempt} спроб вгадати слово\n')

        if user_in == word or count_letter == len(word):  # Перемога
            console.print(f'\n[yellow]Вітаю! Ви вгадали слово:[/yellow]  [green]{word}[/green]')
            if game_again():
                continue
            else:
                break

        if attempt == 0:  # Поразка
            console.print(f'[red]Ви програли :(  {display_hangman(attempt)} слово було -[/red] [blue]{word}[/blue]')
            if game_again():
                continue
            else:
                break
    return True


# функція поточного стану шибиниці

def display_hangman(attempt):
    stages = [  # фінальний стан: голова, тулуб, обидві руки, обидві ноги
        '''
           --------
           |      |
           |      O
           |     \\|/
           |      |
           |     / \\
           -
        ''',
        # голова, тулуб, обидві руки, одна нога
        '''
           --------
           |      |
           |      O
           |     \\|/
           |      |
           |     / 
           -
        ''',
        # голова, тулуб, обидві руки
        '''
           --------
           |      |
           |      O
           |     \\|/
           |      |
           |      
           -
        ''',
        # голова, тулуб и одна рука
        '''
           --------
           |      |
           |      O
           |     \\|
           |      |
           |     
           -
        ''',
        # голова и тулуб
        '''
           --------
           |      |
           |      O
           |      |
           |      |
           |     
           -
        ''',
        # голова
        '''
           --------
           |      |
           |      O
           |    
           |      
           |     
           -
        ''',
        # початковий стан
        '''
           --------
           |      |
           |      
           |    
           |      
           |     
           -
        '''
    ]
    return stages[attempt]


if __name__ == "__main__":
    main()
