import json


def load_json(file_path):
    """Load json function.

    Parameters
    ----------
    file_path : str or pathlib.PosixPath
        json file path

    Returns
    -------
    data : dict
        loaded json data
    """
    with open(str(file_path), "r") as f:
        return json.load(f)


def save_json(data, filename, save_pretty=False, sort_keys=False):
    """Save json function.

    Parameters
    ----------
    data : dict
        save data
    filename : str
        save path
    """
    filename = str(filename)
    with open(filename, "w") as f:
        if save_pretty:
            f.write(json.dumps(data, indent=4, sort_keys=sort_keys))
        else:
            json.dump(data, f)
        f.write('\n')
