"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Server = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const http_1 = require("http");
const os_1 = require("os");
const path_1 = require("path");
class Server {
    constructor(props) {
        this.appCommand = props.appCommand;
        this.server = http_1.createServer((req, res) => this.handleRequest(req, res).catch(e => {
            console.error('server error: ', e);
            res.statusCode = 500;
            res.write(e.message);
            res.end();
        }));
        this.tmpdir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'cdk8s-operator-'));
    }
    /**
     * Starts HTTP server.
     * @param port The port to listen to. If not specified, the `PORT` environment
     * variable will be used. If that's not specified an available port will be
     * auto-selected.
     */
    async listen(port) {
        const lport = port ?? process.env.PORT ?? 0;
        return new Promise((ok, ko) => {
            this.server.listen(lport, () => {
                const addr = this.server.address();
                if (typeof (addr) === 'string') {
                    throw new Error(`cannot determine port from server address ${addr}`);
                }
                return ok(addr?.port);
            });
            this.server.on('error', err => ko(err));
        });
    }
    /**
     * Stop server.
     */
    close() {
        this.server.close();
    }
    async handleRequest(req, res) {
        const inputfile = await this.writeInputFile(req);
        const child = child_process_1.spawn(this.appCommand, [inputfile], {
            stdio: ['ignore', 'pipe', 'pipe'],
            shell: true,
        });
        const stderr = new Array();
        res.setHeader('Content-Type', 'application/json');
        // stdout should go directly to the response
        child.stdout.on('data', chunk => {
            process.stderr.write('output: ' + chunk);
            res.write(chunk);
        });
        // for stderr: write to server terminal and only send back if we exited with a non-zero
        child.stderr.on('data', chunk => {
            process.stderr.write(chunk);
            stderr.push(chunk);
        });
        // will be caused by the async handler and 500 will be returned.
        child.on('error', err => {
            throw err;
        });
        child.on('exit', code => {
            if (code !== 0) {
                res.statusCode = 500;
                for (const c of stderr) {
                    res.write(c);
                }
                res.end();
            }
            // success
            return res.end();
        });
    }
    async writeInputFile(req) {
        return new Promise((ok, ko) => {
            const inputfile = path_1.join(this.tmpdir, `input-${Math.round(Math.random() * 999999)}.json`);
            const input = fs_1.createWriteStream(inputfile);
            req.pipe(input);
            input.on('close', () => {
                try {
                    const inputJson = JSON.parse(fs_1.readFileSync(inputfile, 'utf-8'));
                    console.error(`input: ${JSON.stringify(inputJson)}`);
                    return ok(inputfile);
                }
                catch (e) {
                    return ko(new Error(`unable to parse request body as JSON: ${e}`));
                }
            });
            req.on('error', err => ko(err.message));
        });
    }
}
exports.Server = Server;
_a = JSII_RTTI_SYMBOL_1;
Server[_a] = { fqn: "cdk8s-operator.Server", version: "0.1.20" };
//# sourceMappingURL=data:application/json;base64,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