//! Rules from [flake8-builtins](https://pypi.org/project/flake8-builtins/2.0.1/).
pub(crate) mod rules;
pub(crate) mod types;

#[cfg(test)]
mod tests {
    use std::convert::AsRef;
    use std::path::Path;

    use anyhow::Result;
    use test_case::test_case;

    use crate::linter::test_path;
    use crate::registry::RuleCode;
    use crate::settings;

    #[test_case(RuleCode::A001, Path::new("A001.py"); "A001")]
    #[test_case(RuleCode::A002, Path::new("A002.py"); "A002")]
    #[test_case(RuleCode::A003, Path::new("A003.py"); "A003")]
    fn rules(rule_code: RuleCode, path: &Path) -> Result<()> {
        let snapshot = format!("{}_{}", rule_code.as_ref(), path.to_string_lossy());
        let diagnostics = test_path(
            Path::new("./resources/test/fixtures/flake8_builtins")
                .join(path)
                .as_path(),
            &settings::Settings::for_rule(rule_code),
        )?;
        insta::assert_yaml_snapshot!(snapshot, diagnostics);
        Ok(())
    }
}
