"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool", {
                passwordPolicy: {
                    minLength: 8,
                    requireLowercase: true,
                    requireUppercase: true,
                    requireDigits: true,
                    requireSymbols: true,
                },
                mfa: aws_cognito_1.Mfa.REQUIRED,
                accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
                autoVerify: {
                    email: true,
                },
            });
            this.userPool.node.defaultChild.userPoolAddOns = {
                advancedSecurityMode: "ENFORCED",
            };
            const stack = aws_cdk_lib_1.Stack.of(this);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                {
                    id: "AwsSolutions-IAM5",
                    reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                    appliesTo: ["Resource::*"],
                },
            ]);
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [
                            new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
                                userPool: this.userPool,
                                userPoolClient: this.userPoolClient,
                            }),
                        ]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.12.18" };
//# sourceMappingURL=data:application/json;base64,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