from mock_generator import CFileParser
import os
import shutil
import argparse

class TestRunnerGenerator():
    def __init__(self, test_file):
        self.test_file = test_file
        self.method_list = CFileParser(test_file).extract_method_from_source()
        self.include_list = CFileParser(test_file).extract_included_header()
        self.output_folder = "test_runner"
        try:
            os.makedirs(self.output_folder)
        except:
            pass
        self.test_file_name = os.path.basename(test_file)
        self.runner_name = self.test_file_name[:-2]+"_Runner"+self.test_file_name[-2:]
        self.gen_common()
        self.gen_include()
        self.gen_func()
        self.gen_other()
        self.gen_main()

    def gen_common(self):
        with open(os.path.join(self.output_folder, self.runner_name), 'w') as f:
            f.write("/* Autogenerated, do not edit */\n")
            f.write("/* Test runner definition */\n")
            f.write("#define RUN_TEST(TestFunc, TestLineNum) \\\n")
            f.write("{ \\\n")
            f.write("\tUnity.CurrentTestName = #TestFunc; \\\n")
            f.write("\tUnity.CurrentTestLineNumber = TestLineNum; \\\n")
            f.write("\tUnity.NumberOfTests++; \\\n")
            f.write("\tUNITY_EXEC_TIME_START(); \\\n")
            f.write("\tif (TEST_PROTECT()) \\\n")
            f.write("\t{ \\\n")
            f.write("\t\tsetUp(); \\\n")
            f.write("\t\tTestFunc(); \\\n")
            f.write("\t} \\\n")
            f.write("\tif (TEST_PROTECT()) \\\n")
            f.write("\t{ \\\n")
            f.write("\t\ttearDown(); \\\n")
            f.write("\t} \\\n")
            f.write("\tUNITY_EXEC_TIME_STOP(); \\\n")
            f.write("\tUnityConcludeTest(); \\\n")
            f.write("}\n\n")

    def gen_include(self):
        with open(os.path.join(self.output_folder, self.runner_name), 'a') as f:
            f.write("#define UNITY_INCLUDE_SETUP_STUBS\n")
            f.write("#include \"unity.h\"\n")
            f.write("#ifndef UNITY_EXCLUDE_SETJMP_H\n")
            f.write("#include <setjmp.h>\n")
            f.write("#endif\n")
            f.write("#include <stdio.h>\n")
            f.write("#include \"fff.h\"\n")
            for include in self.include_list:
                if("unity.h" not in include 
                    and "fff.h" not in include
                    and not include.endswith(".c")):
                    if(include.startswith("mock_")):
                        include = include[5:]
                    f.write("#include \"%s\"\n"%include)
            f.write("\n")

    def gen_func(self):
        for func in self.method_list:
            func_splt = func.split(":")
            with open(os.path.join(self.output_folder, self.runner_name), 'a') as f:
                f.write("extern %s %s%s;\n"%(func_splt[3], func_splt[1],func_splt[4]))

    def gen_other(self):
        with open(os.path.join(self.output_folder, self.runner_name,), 'a') as f:
            f.write("""
/*=======Suite Setup=====*/
static void suite_setup(void)
{
    #if defined(UNITY_WEAK_ATTRIBUTE) || defined(UNITY_WEAK_PRAGMA)
    suiteSetUp();
    #endif
}

/*=======Suite Teardown=====*/
static int suite_teardown(int num_failures)
{
    #if defined(UNITY_WEAK_ATTRIBUTE) || defined(UNITY_WEAK_PRAGMA)
    return suiteTearDown(num_failures);
    #else
    return num_failures;
    #endif
}

/*=======Test Reset Option=====*/
void resetTest(void);
void resetTest(void)
{
    tearDown();
    setUp();
}\n\n""")

    def gen_main(self):
        with open(os.path.join(self.output_folder, self.runner_name), 'a') as f:
            f.write("int main(void)\n")
            f.write("{\n")
            f.write("\tsuite_setup();\n")
            f.write("\tUnityBegin(\"%s\");\n"%os.path.realpath(self.test_file))
            for func in self.method_list:
                func_splt = func.split(":")
                if(func_splt[1].startswith("test_")):
                    f.write("\tRUN_TEST(%s, %s);\n"%(func_splt[1], func_splt[0]))
            f.write("\treturn suite_teardown(UnityEnd());\n")
            f.write("}")


def main():
    parser = argparse.ArgumentParser("TestRunnerGenerator")
    parser.add_argument("--test_file")
    args = parser.parse_args()
    TestRunnerGenerator(args.test_file)

if __name__ == '__main__':
    main()