stype = """
/* === Shared === */
QStackedWidget, QLabel, QPushButton, QRadioButton, QCheckBox, 
QGroupBox, QStatusBar, QToolButton, QComboBox, QDialog {
    background-color: #222222;
    color: #BBBBBB;
    font-family: "Segoe UI";
}

/* === QWidget === */
QWidget:window {
    background: #222222;
    color: #BBBBBB;
    font-family: "Segoe UI";
}

/* === QToolTip === */
QToolTip {
    background-color: #000000;
    border: 2px solid #333333;
    color: antiquewhite;
}

/* === QPushButton === */
QPushButton {
    border: 1px solid #333333;
    padding: 4px;
    min-width: 65px;
    min-height: 12px;
}

QPushButton:hover {
    background-color: #333333;
    border-color: #444444;
}

QPushButton:pressed {
    background-color: #111111;
    border-color: #333333;
    color: antiquewhite;
}

QPushButton:disabled {
    color: #333333;
}

/* === Checkable items === */
QCheckBox::indicator, QRadioButton::indicator, QTreeView::indicator {
    width: 16px;
    height: 16px;
    background-color: #111111;
    border: 1px solid #333333;
}

QRadioButton::indicator {
    border-radius: 8px;
}

QCheckBox::indicator::checked, QRadioButton::indicator::checked, QTreeView::indicator::checked {
    background-color: qradialgradient(cx:0.5, cy:0.5, fx:0.25, fy:0.15, radius:0.3, stop:0 #BBBBBB, stop:1 #111111);
}

QCheckBox::indicator:disabled, QRadioButton::indicator:disabled, QTreeView::indicator:disabled {
    background-color: #444444;
}

QCheckBox::indicator::checked:disabled, QRadioButton::indicator::checked:disabled, QTreeView::indicator::checked:disabled {
    background-color: qradialgradient(cx:0.5, cy:0.5, fx:0.25, fy:0.15, radius:0.3, stop:0 #BBBBBB, stop:1 #444444);
}

/* === QComboBox === */
QComboBox {
    background-color: black;
    border: 1px solid #333333;
    color: white;
    padding:1px 2em 1px 3px;
}

QComboBox::drop-down {
    subcontrol-origin: padding;
    subcontrol-position: top right;
    border-left: 1px solid #333333;
}

QComboBox::down-arrow {
    border: 2px solid #333333;
    width: 6px;
    height: 6px;
    background: #5f5f5f;
}

/* === QGroupBox === */
QGroupBox {
    border: 2px solid #333333;
    margin-top: 2ex;
}

QGroupBox::title {
    color: antiquewhite;
    subcontrol-origin: margin;
    subcontrol-position: top left;
    margin-left: 5px;
}

/* === QTabWidget === */
QTabWidget::pane {
    background: #222222;
    border: 2px solid #333333;
}

/* === QTabBar === */
QTabBar::tab {
    background: transparent;
    border: 1px solid #333333;
    border-bottom: none;
    color: #BBBBBB;
    padding-left: 5px;
    padding-right: 10px;
    padding-top: 3px;
    padding-bottom: 3px;
}

QTabBar::tab:hover {
    background-color: #333333;
    border: 1px solid #444444;
    border-bottom: none;
}

QTabBar::tab:selected {
    background-color: #111111;
    border: 1px solid #333333;
    border-top: 1px solid antiquewhite;
    border-bottom: none;
    color: antiquewhite
}

/* === QToolBar === */
QToolBar {
    background-color: #222222;
    border: none;
    padding: 1px;
}

QToolBar:handle {
    background: #222222;
    border-left: 1px dotted antiquewhite;
    color: #BBBBBB;
}

QToolBar::separator {
    width: 6px;
    background-color: #222222;
}

/* === QToolButton === */
QToolButton {
    border: 1px solid #333333;
    margin: 1px;
}

QToolButton:hover {
    background-color: #333333;
    border: 1px solid #444444;
}

QToolButton[popupMode="1"] { /* only for MenuButtonPopup */
    padding-right: 20px; /* make way for the popup button */
}

QToolButton::menu-button {
    border-left: 1px solid #333333;
    background: transparent;
    width: 16px;
}

QToolButton::menu-button:hover {
    border-left: 1px solid #444444;
    background: transparent;
    width: 16px;
}

QToolButton:checked, QToolButton:pressed {
    background-color: #111111;
    color: antiquewhite;
}

/* === QMenu === */
QMenu {
    background-color: black;
    border: 1px solid gray;
    color: white;
    padding: 1px;
}

QMenu::item {
    padding: 2px 25px 2px 20px;
    border: 1px solid transparent;
}

QMenu::item:disabled {
    color: #666666;
}

QMenu::item:selected {
    border-color: gray;
    background: #222222;
}

QMenu::icon:checked {

}

QMenu::separator {
    height: 1px;
    background: #222222;
    margin-left: 10px;
    margin-right: 10px;
    margin-top: 1px;
    margin-bottom: 1px;
}

QMenu::indicator {
    width: 13px;
    height: 13px;
}

/* === QMenuBar === */
QMenuBar {
    background-color: black;
    color: white;
}

QMenuBar::item {
    background: transparent;
}

QMenuBar::item:disabled {
    color: gray;
}

QMenuBar::item:selected {
    background: #222222;
}

QMenuBar::item:pressed {
    background: #444444;
}
 
/* === QScrollBar:vertical === */
QScrollBar:vertical {
    background: #111111;
    width: 16px;
    margin: 16px 0 16px 0;
}

QScrollBar::handle:vertical {
    background: #555555;
    min-height: 16px;
}

QScrollBar::add-line:vertical {
    background: #444444;
    height: 16px;
    subcontrol-position: bottom;
    subcontrol-origin: margin;
}

QScrollBar::sub-line:vertical {
    background: #444444;
    height: 16px;
    subcontrol-position: top;
    subcontrol-origin: margin;
}

QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical {
    background: none;
}

QScrollBar:up-arrow:vertical, QScrollBar:down-arrow:vertical {
    border: 2px solid #333333;
    width: 6px;
    height: 6px;
    background: #5f5f5f;
}

/* === QScrollBar:horizontal === */
QScrollBar:horizontal {
    background: #111111;
    height: 16px;
    margin: 0 16px 0 16px;
}

QScrollBar::handle:horizontal {
    background: #555555;
    min-width: 16px;
}

QScrollBar::add-line:horizontal {
    background: #444444;
    width: 16px;
    subcontrol-position: right;
    subcontrol-origin: margin;
}

QScrollBar::sub-line:horizontal {
    background: #444444;
    width: 16px;
    subcontrol-position: left;
    subcontrol-origin: margin;
}

QScrollBar::add-page:horizontal, QScrollBar::sub-page:horizontal {
    background: none;
}

QScrollBar:left-arrow:horizontal, QScrollBar:right-arrow:horizontal {
    border: 2px solid #333333;
    width: 6px;
    height: 6px;
    background: #5f5f5f;
}

/* =================== */
QLineEdit, QListView, QTreeView, QTableView, QAbstractSpinBox {
    background-color: black;
    color: #BBBBBB;
    border: 1px solid #333333;
}

QAbstractScrollArea, QLineEdit, QTextEdit, QAbstractSpinBox, QComboBox {
    border-color: #333333;
    border: 1px solid #333333;

}

/* === QHeaderView === */
QHeaderView::section {
    background: #222222;
    border: 0;
    color: #BBBBBB;
    padding: 3px 0 3px 4px;
}

/* === QListView === */
QListView::item:hover {
    background: #333333;
}

QListView::item:selected {
    background: #111111;
    color: antiquewhite;
}

/* === QTableView === */
QTableView::item:hover {
    background: #333333;
}

QTableView::item:hover {
    background: #111111;
    color: antiquewhite;
}

/* === QTreeView === */
QTreeView::item {
    background: black;
}

QTreeView::item:hover {
    background: #333333;
}

QTreeView::item:selected {
    background: #111111;
    color: antiquewhite;
}

QTreeView::branch {

}

QTreeView::branch:has-siblings:adjoins-item {

}

QTreeView::branch:has-siblings:!adjoins-item {

}

QTreeView::branch:closed:has-children:has-siblings {

}

QTreeView::branch:has-children:!has-siblings:closed {

}

QTreeView::branch:!has-children:!has-siblings:adjoins-item {

}

QTreeView::branch:open:has-children:has-siblings {

}

QTreeView::branch:open:has-children:!has-siblings {

}

/* === Customizations === */
QFrame#infoLabel {
    border: 1px inset #333333;
}
2.

.QWidget {
   background-color: beige;
}

QToolBar {
    background-color: beige;
}

QDialog, QFileDialog {
    background-color: beige;
}

QTabWidget::pane { /* The tab widget frame */
    border-top: 2px solid #C2C7CB;
}

QTabWidget::tab-bar {
    left: 5px; /* move to the right by 5px */
}

QTabBar, QTabWidget {
    background-color: beige;
}
QTabBar::tab {
     background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,
                                 stop: 0 #E1E1E1, stop: 0.4 #DDDDDD,
                                 stop: 0.5 #D8D8D8, stop: 1.0 #D3D3D3);
     border: 1px solid darkkhaki;
     border-bottom-color: #C2C7CB; /* same as the pane color */
     border-top-left-radius: 4px;
     border-top-right-radius: 4px;
     min-width: 8ex;
     padding: 2px;
 }
QTabBar::tab:selected, QTabBar::tab:hover {
    background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,
                                stop: 0 #fafafa, stop: 0.4 #f4f4f4,
                                stop: 0.5 #e7e7e7, stop: 1.0 #fafafa);
}

QTabBar::tab:selected {
    border-color: #9B9B9B;
    border-bottom-color: #C2C7CB; /* same as pane color */
}

QTabBar::tab:!selected {
    margin-top: 2px; /* make non-selected tabs look smaller */
}

/* Nice Windows-XP-style password character. */
QLineEdit[echoMode="2"] {
    lineedit-password-character: 9679;
}

QHeaderView::section {
     background-color: qlineargradient(x1:0, y1:0, x2:0, y2:1,
                                       stop:0 #616161, stop: 0.5 #505050,
                                       stop: 0.6 #434343, stop:1 #656565);
     color: white;
     padding-left: 4px;
     border: 1px solid #6c6c6c;
 }

 QHeaderView::section:checked
 {
     background-color: red;
 }


/* We provide a min-width and min-height for push buttons
   so that they look elegant regardless of the width of the text. */
QPushButton {
    background-color: palegoldenrod;
    border-width: 2px;
    border-color: darkkhaki;
    border-style: solid;
    border-radius: 5;
    padding: 3px;
    min-width: 9ex;
    min-height: 2.5ex;
}

QPushButton:hover {
   background-color: khaki;
}

/* Increase the padding, so the text is shifted when the button is
   pressed. */
QPushButton:pressed {
    padding-left: 5px;
    padding-top: 5px;
    background-color: #d0d67c;
}

QLabel, QAbstractButton {
    font: bold;
}

/* Mark mandatory fields with a brownish color. */
.mandatory {
    color: brown;
}

/* Bold text on status bar looks awful. */
QStatusBar QLabel {
   font: normal;
}

QStatusBar::item {
    border-width: 1;
    border-color: darkkhaki;
    border-style: solid;
    border-radius: 2;
}

QStackedWidget, QComboBox, QLineEdit, QSpinBox, QTextEdit, QListView, QWebView, QTreeView, QHeaderView {
    background-color: cornsilk;
    selection-color: #0a214c; 
    selection-background-color: #C19A6B;
}

QListView {
    show-decoration-selected: 1;
}

QListView::item:hover {
    background-color: wheat;
}

/* We reserve 1 pixel space in padding. When we get the focus,
   we kill the padding and enlarge the border. This makes the items
   glow. */
QLineEdit, QFrame {
    border-width: 1px;
    padding: 1px;
    border-style: solid;
    border-color: darkkhaki;
    border-radius: 5px;
}

/* As mentioned above, eliminate the padding and increase the border. */
QLineEdit:focus, QFrame:focus {
    border-width: 3px;
    padding: 0px;
}

/* A QLabel is a QFrame  */
QLabel {
    border: none;
    padding: 0;
    background: none;
}

/* A QToolTip is a QLabel  */
QToolTip {
    border: 2px solid darkkhaki;
    padding: 5px;
    border-radius: 3px;
    opacity: 200;
}

/* Nice to have the background color change when hovered. */
QRadioButton:hover, QCheckBox:hover {
    background-color: wheat;
}

/* Force the dialog's buttons to follow the Windows guidelines. */
QDialogButtonBox {
    button-layout: 0;
}


3.
/*
    Style by evilworks, 2012-2013. pollux@lavabit.com
    This file is Public Domain.
*/

/* === Shared === */
QStackedWidget, QLabel, QPushButton, QRadioButton, QCheckBox, 
QGroupBox, QStatusBar, QToolButton, QComboBox, QDialog, QTabBar {
    font-family: "Segoe UI";
    background-color: #888;
    color: #000;
}

/* === QWidget === */
QWidget:window {
    font-family: 'Segoe UI';
    background-color: #888;
}

/* === QPushButton === */
QPushButton {
    border: 1px solid #555;
    padding: 4px;
    min-width: 65px;
    min-height: 12px;
}

QPushButton:hover {
    background-color: #999;
}

QPushButton:pressed {
    background-color: #333;
    border-color: #555;
    color: #AAA;
}

QPushButton:disabled {
    color: #333333;
}

/* === QComboBox === */
QComboBox {
    background-color: #AAA;
    border: 1px solid #555;
    color: black;
}

QComboBox::drop-down {
    subcontrol-origin: padding;
    subcontrol-position: top right;
    border-left: 1px solid #333333;
}

/* === QGroupBox === */
QGroupBox {
    border: 1px solid #555;
    margin-top: 2ex;
}

QGroupBox::title {
    color: black;
    subcontrol-origin: margin;
    subcontrol-position: top left;    
    border: 1px solid #555;
}

/* === QTabBar === */
QTabBar::tab {
    border-bottom: none;
    color: #000;
    padding: 4px;
    background-color: #888;
    border: 1px solid #555;
}

QTabBar::tab:hover {
    background-color: #AAA;
}

QTabBar::tab:selected {
    background-color: #000;
    color: white;
}

/* === QTabWidget === */
QTabWidget::pane {
    background: #888;
    border: 1px solid #555;
}


/* === QToolBar === */
QToolBar {
    background: #949494;
    border: none;
    padding-left: 0px;
    padding-right: 0px;
    margin: 2px;
}

QToolBar::separator {
    width: 1px;
    margin-left: 3px;
    margin-right: 3px;
    background-color: #555;
}

/* === QToolButton === */
QToolButton {
    border: 1px solid #666;
    margin: 1px;
}

QToolButton:hover {
    background-color: #AAA;
}

QToolButton[popupMode="1"] { /* only for MenuButtonPopup */
    padding-right: 20px; /* make way for the popup button */
}

QToolButton::menu-button {
    border-left: 1px solid #666;
    background: transparent;
    width: 16px;
}

QToolButton::menu-button:hover {
    border-left: 1px solid #666;
    background: transparent;
    width: 16px;
}

QToolButton:checked, QToolButton:pressed {
    background-color: #000;
    border: 1px solid #555;
    color: white;
}

/* === QScrollBar:vertical === */
QScrollBar:vertical {
    width: 16px;
    margin: 16px 0 16px 0;
    background: #333;
}

QScrollBar::handle:vertical {
    background: #888;
    min-height: 16px;
    border-top: 1px solid #666;
    border-bottom: 1px solid #666;
}

QScrollBar::add-line:vertical {
    background: #888;
    height: 16px;
    subcontrol-position: bottom;
    subcontrol-origin: margin;
}

QScrollBar::sub-line:vertical {
    background: #888;
    height: 16px;
    subcontrol-position: top;
    subcontrol-origin: margin;
}

QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical {
    background: none;
}

/* === QScrollBar:horizontal === */
QScrollBar:horizontal {
    height: 16px;
    margin: 0 16px 0 16px;
    background: #333;
}

QScrollBar::handle:horizontal {
    background: #888;
    min-width: 16px;
    border-left: 1px solid #666;
    border-right: 1px solid #666;
}

QScrollBar::add-line:horizontal {
    background: #888;
    width: 16px;
    subcontrol-position: right;
    subcontrol-origin: margin;
}

QScrollBar::sub-line:horizontal {
    background: #888;
    width: 16px;
    subcontrol-position: left;
    subcontrol-origin: margin;
}

QScrollBar::add-page:horizontal, QScrollBar::sub-page:horizontal {
    background: none;
}

/* === QMenu === */
QMenu {
    background-color: black;
    border: 1px solid gray;
    color: white;
    padding: 1px;
}

QMenu::item {
    padding: 2px 25px 2px 20px;
    border: 1px solid transparent;
}

QMenu::item:disabled {
    color: #666666;
}

QMenu::item:selected {
    border-color: gray;
    background: #222222;
}

QMenu::icon:checked {

}

QMenu::separator {
    height: 1px;
    background: #222222;
    margin-left: 10px;
    margin-right: 10px;
    margin-top: 1px;
    margin-bottom: 1px;
}

QMenu::indicator {
    width: 13px;
    height: 13px;
}

/* === QMenuBar === */
QMenuBar {
    background-color: black;
    color: white;
}

QMenuBar::item {
    background: transparent;
}

QMenuBar::item:disabled {
    color: gray;
}

QMenuBar::item:selected {
    background: #222222;
}

QMenuBar::item:pressed {
    background: #444444;
}
/* =================== */
QLineEdit, QListView, QTreeView, QTableView, QAbstractSpinBox {
    background-color: #AAA;
    color: #000;
    border: 1px solid #555;
}

QAbstractScrollArea, QLineEdit, QTextEdit, QAbstractSpinBox, QComboBox {
    border: 1px solid #555;
}

/* === QHeaderView === */
QHeaderView::section {
    height: 20px;
}

QHeaderView::section {
    background: #666;
    border: 0;
    color: #000;
    padding-left: 4px;
}

/* === QListView === */
QListView::item:hover {
    background: #AAA;
}

QListView::item:selected {
    background: #333;
    color: #AAA;
}

/* === QTableView === */
QTableView::item:hover {
    background: #333333;
}

QTableView::item:hover {
    background: #111111;
    color: antiquewhite;
}

/* === QTreeView === */
QTreeView::item {
    background: #AAA;
}

QTreeView::item:hover {
    background: #CCC;
}

QTreeView::item:selected {
    background: #333;
    color: #AAA;
}

QTreeView::branch {

}

QTreeView::branch:has-siblings:adjoins-item {

}

QTreeView::branch:has-siblings:!adjoins-item {

}

QTreeView::branch:closed:has-children:has-siblings {

}

QTreeView::branch:has-children:!has-siblings:closed {

}

QTreeView::branch:!has-children:!has-siblings:adjoins-item {

}

QTreeView::branch:open:has-children:has-siblings {

}

QTreeView::branch:open:has-children:!has-siblings {

}
"""