"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _1 = require("./");
class IntegTesting {
    constructor(props = {}) {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const vpc = props.vpc ?? getOrCreateVpc(stack);
        const provider = new _1.Provider(stack, 'GitlabProvider', { vpc });
        // create a Amazon EKS cluster
        provider.createFargateEksCluster(stack, 'GitlabEksCluster', {
            clusterOptions: {
                vpc,
                version: aws_cdk_lib_1.aws_eks.KubernetesVersion.V1_19,
            },
        });
        // create a default fargate runner with its job executor
        provider.createFargateRunner();
        // alternatively, create the runner and the executor indivicually.
        // first, create the executor
        const executor = new _1.FargateJobExecutor(stack, 'JobExecutor', {
            image: _1.JobExecutorImage.JSII,
        });
        // second,create the runner with the task definition of the executor
        new _1.FargateRunner(stack, 'FargateRunner', {
            vpc,
            executor,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
process.env.GITLAB_REGISTRATION_TOKEN = 'mock';
process.env.CDK_INTEG_REGION = 'us-east-1';
new IntegTesting();
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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