import logging

from dotenv import load_dotenv

from loralogger.config.settings import ConfigBuilder

# Load the environment variables
load_dotenv()

# Configuration
config = ConfigBuilder.from_env()

# Initialize the worker
try:
    from Connector import Worker

    worker = Worker.create(
        node_name="logger-producer",
        app_name="logger producer",
        worker_queue_name="logger",
        broker_url=config.broker_url,
        result_backend=config.result_backend,
    )
except Exception:
    logging.exception("Cannot initialize producer")
