"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var framework_helpers_exports = {};
__export(framework_helpers_exports, {
  BACKEND_BUILDERS: () => BACKEND_BUILDERS,
  BACKEND_FRAMEWORKS: () => BACKEND_FRAMEWORKS,
  isBackendBuilder: () => isBackendBuilder,
  isBackendFramework: () => isBackendFramework,
  isExperimentalBackendsEnabled: () => isExperimentalBackendsEnabled,
  shouldUseExperimentalBackends: () => shouldUseExperimentalBackends
});
module.exports = __toCommonJS(framework_helpers_exports);
const BACKEND_FRAMEWORKS = [
  "express",
  "hono",
  "h3",
  "nestjs",
  "fastify",
  "elysia"
];
const BACKEND_BUILDERS = [
  "@vercel/express",
  "@vercel/hono",
  "@vercel/h3",
  "@vercel/nestjs",
  "@vercel/fastify",
  "@vercel/elysia"
];
function isBackendFramework(framework) {
  if (!framework)
    return false;
  return BACKEND_FRAMEWORKS.includes(framework);
}
function isExperimentalBackendsEnabled() {
  return process.env.VERCEL_EXPERIMENTAL_BACKENDS === "1" || // Previously used for experimental express and hono builds
  process.env.VERCEL_EXPERIMENTAL_EXPRESS_BUILD === "1" || process.env.VERCEL_EXPERIMENTAL_HONO_BUILD === "1";
}
function isBackendBuilder(builder) {
  if (!builder)
    return false;
  const use = builder.use;
  return BACKEND_BUILDERS.includes(use);
}
function shouldUseExperimentalBackends(framework) {
  return isExperimentalBackendsEnabled() && isBackendFramework(framework);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BACKEND_BUILDERS,
  BACKEND_FRAMEWORKS,
  isBackendBuilder,
  isBackendFramework,
  isExperimentalBackendsEnabled,
  shouldUseExperimentalBackends
});
