# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_pprint.ipynb (unless otherwise specified).

__all__ = ['B_', 'E_', 'R_', 'L_', 'printmd', 'pTab_S', 'pTab', 'PT_S', 'PT', 'PP_ST', 'PP_S', 'PP_H', 'PP', 'PPT']

# Cell
# if IN_COLAB:
#     def __insCol():
#         try:
#           !pip install colorama
#         except:
#           None
#     __insCol()

from colorama import Fore, Back, Style
B_ = Style.BRIGHT
E_ = Style.RESET_ALL
R_ = Fore.RED
L_ = Fore.BLACK

# Cell
from IPython.display import Markdown, HTML, display

# Cell
def printmd(*args, color=None, **kwargs):
  colorStr = '<span style=\"color:{}\">{}</span>'.format(color, ' '.join(str(x) for x in args))
  display(Markdown(colorStr), **kwargs)

# Cell
from tabulate import tabulate

# Cell
def pTab_S(tab=[], headers=[], rowLabels=[], fmt='plain', **kwargs):
  headers = [B_+head+E_ for head in (([''] if len(rowLabels) else []) + headers)]
  rowLabels = [B_+row+E_ for row in rowLabels]
  return tabulate([[rowLabels[i], *row] for i, row in enumerate(tab)] if len(rowLabels) else tab,
            headers=headers,
            tablefmt=fmt,
            **kwargs)

def pTab(*args, **kwargs):
  print(pTab_S(*args, **kwargs))

PT_S = pTab_S
PT = pTab

# Cell
_nl = '\n'
_formatKey = lambda k, bb, be : f'{bb}{k.replace(_nl,"")}{be}'

def _getPairs(*pairs, bb=B_, be=E_, suf=': ', **kwargs):
  headersKwArgs, dataKwArgs = (), () if len(kwargs) < 1 else kwargs.items()
  a = [(f'{_formatKey(prev, bb, be)}{suf}' if len(prev)>0 else '',
        f'{"" if len(prev)>0 and prev[-1] != _nl else _nl}{curr}')
          for prev, curr in zip(pairs[::2] + headersKwArgs, pairs[1::2] + dataKwArgs)]
  return a


def PP_ST(*pairs, sep='', tab=0, rowLabels=[], fmt='simple', **kwargs):
  a = _getPairs(*pairs, suf='', **kwargs)
  headers, data = list(zip(*a))
  return tabulate((data,), headers=headers, tablefmt=fmt)

def PP_S(*pairs, sep='', tab=0, **kwargs):
  a = [item for sublist in _getPairs(*pairs, **kwargs) for item in sublist]
  return '  '*tab + f' {sep} '.join(a)

def PP_H(*pairs, sep='', tab=0, **kwargs):
  a = _getPairs(*pairs, bb='<strong>', be='</strong>', **kwargs)
  t = '<span>' + '&nbsp;&nbsp;&nbsp;&nbsp;'*tab + '</span>'
  return '<p>' + t + f' &nbsp;{sep}&nbsp; '.join(a) + '</p>'

def PP(*pairs, **kwargs):
  print(PP_S(*pairs, **kwargs))

def PPT(*pairs, **kwargs):
  print(PP_ST(*pairs, **kwargs))