# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_imports.ipynb (unless otherwise specified).

__all__ = ['np', 'pd', 'in_colab', 'in_notebook', 'IN_COLAB', 'IN_COLAB', 'IN_NOTEBOOK', 'gwidgets', 'widgets',
           'gwidgets', 'go', 'px', 'make_subplots', 'Digraph', 'tabulate', 'master_bar', 'progress_bar',
           'workaround_empty_console_output', 'PIL', 'Image', 'pxShowImg', 'showarray', 'pilToPNG']

# Cell
import numpy as np
#nbdev_comment _all_ = ["np"]

# Cell
import pandas as pd
#nbdev_comment _all_ = ["pd"]

# Cell
import IPython
from IPython.display import Markdown, display, HTML

# Cell
import sys
IN_COLAB = 'google.colab' in sys.modules

# from fastprogress
def in_colab():
  'Check if the code is running in Google Colaboratory'
  try:
    from google import colab
    return True
  except: return False

IN_COLAB = in_colab()

def in_notebook():
  'Check if the code is running in a jupyter notebook'
  if in_colab(): return True
  try:
    shell = get_ipython().__class__.__name__
    if shell == 'ZMQInteractiveShell': # Jupyter notebook, Spyder or qtconsole
      import IPython
      #IPython version lower then 6.0.0 don't work with output you update
      return IPython.__version__ >= '6.0.0'
    elif shell == 'TerminalInteractiveShell': return False  # Terminal running IPython
    else: return False  # Other type (?)
  except NameError: return False      # Probably standard Python interpreter

IN_NOTEBOOK = in_notebook()

# Cell
import ipywidgets as widgets

gwidgets = None
if IN_COLAB:
    from google.colab import widgets as gwidgets
#nbdev_comment _all_ = ["widgets", "gwidgets"]

# Cell
import plotly.graph_objects as go
import plotly.express as px
from plotly.subplots import make_subplots
#nbdev_comment _all_ = ["go", "px", "make_subplots"]

# Cell
from graphviz import Digraph
#nbdev_comment _all_ = ["Digraph"]

# Cell
from tabulate import tabulate
#nbdev_comment _all_ = ["tabulate"]

# Cell
# from tensorflow.keras.datasets import mnist

# Cell
from fastprogress.fastprogress import master_bar, progress_bar, workaround_empty_console_output
#nbdev_comment _all_ = ["master_bar", "progress_bar", "workaround_empty_console_output"]

# Cell
import PIL
from PIL import Image
#nbdev_comment _all_ = ["PIL", "Image"]

# Cell
def pxShowImg(*args, **kwargs):
  fig=px.imshow(*args, **kwargs)
  fig.update_layout(coloraxis_showscale=False)
  fig.update_xaxes(showticklabels=False)
  fig.update_yaxes(showticklabels=False)
  fig.update_layout(margin=dict(pad=0, t=0, b=0, l=0, r=0, ))
  return fig

# Cell
from io import BytesIO
def showarray(a, fmt='png'):
    a = np.uint8(a)
    f = BytesIO()
    Image.fromarray(a).save(f, fmt)
    return display.Image(data=f.getvalue())

# Cell
from base64 import b64encode
def pilToPNG(pil_im):
  b = BytesIO()
  pil_im.save(b, format='png')
  return b.getvalue()