# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['telegram_stats_bot']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'matplotlib>=3.2.1,<4.0.0',
 'numpy>=1.18.4,<2.0.0',
 'pandas>=1.0.4,<2.0.0',
 'python-telegram-bot>=12.7,<13.0',
 'seaborn>=0.10.1,<0.11.0',
 'sqlalchemy-utils>=0.36.6,<0.37.0',
 'sqlalchemy[postgresql_psycopg2binary]>=1.3.17,<2.0.0']

extras_require = \
{':python_version < "3.8"': ['typing_extensions>=3.7.4,<4.0.0']}

setup_kwargs = {
    'name': 'telegram-stats-bot',
    'version': '0.1.1',
    'description': 'A logging and statistics bot for Telegram based on python-telegram-bot.',
    'long_description': '==================\ntelegram-stats-bot\n==================\n\n.. image:: https://img.shields.io/pypi/v/telegram-stats-bot?style=flat-square\n   :target: https://pypi.org/project/telegram-stats-bot/\n   :alt: PyPi Package Version\n\n.. image:: https://img.shields.io/pypi/pyversions/telegram-stats-bot?style=flat-square\n   :target: https://pypi.org/project/telegram-stats-bot/\n   :alt: Supported Python versions\n\n.. image:: https://img.shields.io/github/commit-activity/m/mkdryden/telegram-stats-bot?style=flat-square\n   :target: https://github.com/mkdryden/telegram-stats-bot\n   :alt: GitHub Commit Activity\n\n.. image:: https://img.shields.io/pypi/v/telegram-stats-bot?style=flat-square\n   :target: https://pypi.org/project/telegram-stats-bot/\n   :alt: PyPi Package Version\n\n.. image:: https://img.shields.io/pypi/l/telegram-stats-bot?style=flat-square\n   :target: https://www.gnu.org/licenses/gpl-3.0-or-later.html\n   :alt: LGPLv3 License\n\n\nTelegram-stats-bot is a simple bot that lives in your Telegram group, logging messages to a Postgresql database and\nserving statistical tables and plots to users as Telegram messages.\n\n.. image:: examples/chat_example.png\n    :alt: Bot conversation example\n\n-----------------\nTable of contents\n-----------------\n\n- `Introduction`_\n\n- `Basic Requirements`_\n\n- `Installation`_\n\n- `Setup`_\n\n- `Fetching Stats`_\n\n- `counts`_\n\n  - `hours`_\n\n  - `days`_\n\n  - `week`_\n\n  - `history`_\n\n  - `corr`_\n\n  - `delta`_\n\n- `License`_\n\n------------\nIntroduction\n------------\n\nThis software is intended to be run on a server, handling updates for a bot user with a single bot per channel\n(multi-channel support could be added at some point if there is interest), using the excellent\n`Python-telegram-bot <https://github.com/python-telegram-bot/python-telegram-bot>`_ library.\n\nThe bot is still in active development but at the moment, it features:\n\n- Message logging to Postgresql database with optional JSON file backup\n\n- Statistics output for users in group as Telegram messages, with optional filtering by date or limiting to the querying\n  user.\n  Some statistics are more useful than others, but they are mainly intended to be fun for users to play with.\n\n  - Tables:\n\n    - Most active users\n\n    - A user\'s message time correlation with other users\n\n    - A user\'s median message time difference with other users\n\n  - Plots:\n\n    - Message activity by hour of day\n\n    - Message activity by day of week\n\n    - Message activity over the week by hour and day\n\n    - Message activity history\n\n------------------\nBasic Requirements\n------------------\n\n- Python 3.7+\n\n- A Telegram bot token with privacy mode disabled (needed to log messages)\n\n  - See `here <https://core.telegram.org/bots#6-botfather>`_ for details\n\n- Postgresql (Tested with 12.3, but there shouldn\'t be anything that won\'t work with 9.4 or up)\n\n  - This can be on a different system than telegram-stats-bot and requires either table creation permissions on a\n    database or database can be pre-initialized following the setup in ``db.py``\n\n------------\nInstallation\n------------\n\nThe easiest way to install or upgrade is with pip:\n\n.. code:: shell\n\n    $ pip install telegram-stats-bot --upgrade\n\nOr you can install the latest git version:\n\n.. code:: shell\n\n    $ pip install git+git://github.com/mkdryden/telegram-stats-bot.git\n    \nInstalling directly with ``setup.py`` should also work.\n\n-----\nSetup\n-----\nOnce installed, you can run the bot by calling the ``main`` module with a few required arguments:\n\n.. code:: shell\n\n    $ python -m telegram_stats_bot.main BOT_TOKEN CHAT_ID POSTGRESQL_URL\n\n- BOT_TOKEN: Your bot\'s token e.g., ``110201543:AAHdqTcvCH1vGWJxfSeofSAs0K5PALDsaw``\n\n- CHAT_ID: The chat id to monitor (will be a large integer, possibly negative, if unknown, set to 0 and see below)\n\n- POSTGRESQL_URL: Connection information in the form: ``postgresql://USERNAME:PASSWORD@ADDRESS/DB_NAME``\n\n  - if DB_NAME exists, there must not be tables called ``messages_utc``, ``user_events``, or ``user_names``\n    with incorrect columns\n\nOn startup, the bot will attempt to create the database and tables, if they do not already exist.\nIf you do not know the chat\'s id and have set it to 0 as mentioned above, you can send the ``/chatid`` command inside\nthe group, and the bot will reply with it, then restart the bot with the id.\nIf you have forgotten to disable privacy mode, an error will be logged in the terminal.\n\nThe bot will now log all messages in the group, but will only respond to users who have sent a message that has been\nlogged previously (and this list is only updated once an hour, so if you\'re impatient, you can restart the bot after\nyou\'ve sent a message to trigger the update).\nYou can see if messages are being logged correctly by reviewing the terminal output.\nYou should see a line like ``2020-06-04 02:08:39,212 - __main__ - INFO - 8``, whenever a message is logged.\n\n--------------\nFetching Stats\n--------------\nTo fetch stats, simply message the bot, either inside the group being logged, or in a direct message, using the\n``/stats`` command.\n``/stats`` with no arguments prints the table of most active users and other statistics are available through various\nsubcommands.\nAll commands are documented and the built in help can be displayed with ``/stats -h`` or ``stats <subcommand> -h``.\n\nMost commands have optional arguments that change the behaviour of the output.\nNearly all have:\n\n- ``-start`` and ``-end`` followed by a timestamp (e.g., 2019, 2019-01, 2019-01-01, "2019-01-01 14:21") specify the\n  range of data to fetch, otherwise all available data will be used.\n  Either or both options can be given.\n\n- ``-me`` calculates statistics for the user sending the command, rather than all chat users.\n\nSample outputs of each available subcommand follow.\n\ncounts\n------\n``/stats counts`` returns a list of the most active users in the group.\n\n.. code::\n\n                User  Total Messages  Percent\n          @ACoolUser           42150      7.0\n          @NumberOne           37370      6.2\n   @WinstonChurchill           32668      5.4\n            @AAAAAAA           32134      5.4\n  @WhereAreMyManners           30481      5.1\n  @TheWorstOfTheBest           28705      4.8\n\nhours\n-----\n``/stats hours`` returns a plot of message frequency for the hours of the day.\n\n.. image:: examples/hours.jpg\n   :alt: Example of hours plot\n\ndays\n----\n``/stats days`` returns a plot of message frequency for the days of the week.\n\n.. image:: examples/days.jpg\n   :alt: Example of days plot\n\nweek\n----\n``/stats week`` returns a plot of total messages over the data period by day of week and hour of day.\n\n.. image:: examples/week.jpg\n   :alt: Example of week plot\n\nhistory\n-------\n``/stats history`` returns a plot of messages versus date.\n\n.. image:: examples/history.jpg\n   :alt: Example of history plot\n\ncorr\n----\n``/stats corr`` returns a list of users with the highest and lowest message time correlations with the requesting user.\n\n.. code::\n\n    User Correlations for @TheManWhoWasThursday\n    HIGHEST CORRELATION:\n    @MyGoodFriend         0.335\n    @Rawr                 0.302\n    @MangesUnePoutine     0.284\n    @GreenBlood           0.251\n    @TooMuchVacuum        0.235\n\n    LOWEST CORRELATION:\n    @Shiny                0.146\n    @BlueDog              0.142\n    @CoolCat              0.122\n    @EatMe                0.116\n    @JustPassingBy        0.106\n\ndelta\n-----\n``/stats delta`` returns a list of users with the shortest differences in message times with the requesting user.\n\n.. code::\n\n    Median message delays for @KingLeer and:\n    @PolyamorousPasta     00:03:23\n    @AggressiveArgon      00:04:43\n    @AdjectiveNoun        00:08:27\n    @SuperSalad           00:09:05\n    @ABoredProgrammer     00:09:06\n\n----------\nThe Future\n----------\nTelegram-stats-bot is a work in progress.\nNew stats will be added, but no guarantees that the database structure will stay constant if Telegram\'s message\nstructure changes or I need to change something to make a new statistic work.\n\n=======\nLicense\n=======\nTelegram-stats-bot is free software:\nYou can redistribute it and/or modify it under the terms of the\n`GNU General Public License v3.0 or later <https://www.gnu.org/licenses/gpl-3.0.html>`_.\nDerivative works must also be redistributed under the GPL v3 or later.\n',
    'author': 'Michael DM Dryden',
    'author_email': 'mk.dryden@utoronto.ca',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
