# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['redasql']

package_data = \
{'': ['*']}

install_requires = \
['prompt-toolkit>=3.0.20,<4.0.0',
 'pyperclip>=1.8.2,<2.0.0',
 'requests>=2.26.0,<3.0.0',
 'tabulate>=0.8.9,<0.9.0']

entry_points = \
{'console_scripts': ['redasql = redasql.command:main']}

setup_kwargs = {
    'name': 'redasql',
    'version': '2.4.0',
    'description': '',
    'long_description': "# RedaSQL\n![redasql](https://user-images.githubusercontent.com/4572217/138800787-b9525acd-8ab1-4f35-a762-948244b9caee.png)\n\n\nRedaSQL is querying tool for redash.\nI like `psql`(PostgreSQL CLI). so redasql resemble psql in some respects.\n\n## Install\n\n```bash\npip install redasql\n```\n\n## supported readsh version\n\nRedaSQL supports Redash v8, v9 and v10.RedaSQL supports Redash v8, v9 and v10.\n\n## How To Use\n\nredasql need some arguments or environment variables.\nredasql prioritizes arguments over environment variables.\n\n\n| argument         | env                     | mean                                                                                                        |required|\n|------------------|-------------------------|-------------------------------------------------------------------------------------------------------------|---|\n| -k/--api-key     | REDASQL_REDASH_APIKEY   | API KEY(user api key)                                                                                       |True|\n| -s/--server-host | REDASQL_REDASH_ENDPOINT | Redash server hostname. ex) https://your.redash.server.host/                                                |True|\n| -p/--proxy       | REDASQL_HTTP_PROXY      | if your redash server restricted by Proxy, set url format. ex)http://user:pass@your.proxy.server:proxy-port |False|\n| -d/--data-source | None                    | initial connect datasource name.                                                                            | False                                                                                                       |\n| --ignore-rc      | None                    | ignore `.redasqlrc` file                                                                                    | False(default false) |\n| --debug          | None                    | debug mode                                                                                                  | False(default false) |\n\n\nif you want to use redasql with direnv, rename `.envrc.sample` to `.envrc` and set attributes.\n\n### special commands\n\nredasql has management commands.\n\n```\nmetadata=# \\?\n\\?: HELP META COMMANDS.\n\\q: EXIT.\n\\d: DESCRIBE TABLE\n\\c: SELECT DATASOURCE.\n\\x: QUERY RESULT TOGGLE PIVOT.\n\\f: CHANGE RESULT FORMATTER ['table', 'markdown', 'markdown_with_sql', 'csv'].\n\\l: LOAD QUERY FROM REDASH.\n\\o: CHANGE THE OUTPUT DESTINATION TO ['stdout', 'stdout_and_clipboard'].\n```\n\n### execute query\n\nsee below\n\n#### start\n```\n$ redasql\n\n ____          _       ____   ___  _     \n|  _ \\ ___  __| | __ _/ ___| / _ \\| |    \n| |_) / _ \\/ _` |/ _` \\___ \\| | | | |    \n|  _ <  __/ (_| | (_| |___) | |_| | |___ \n|_| \\_\\___|\\__,_|\\__,_|____/ \\__\\_\\_____|\n\n    - redash query cli tool -\n\nSUCCESS CONNECT\n- server version 8.0.0+b32245\n- client version 0.1.0\n\n(No DataSource)=#\n```\n\n#### connect datasource\n\nuse `\\c data_source_name`. if not provide data_source_name, show all available data sources. \n\n```\n(No DataSource)=# \\c metadata\nmetadata=#\n```\n\n#### describe table\n\nuse `\\d table_name`. if not provide table_name, show all table names. if provide table_name with wildcard(\\*), show describe matched tables.\n\n```\nmetadata=# \\d\naccess_permissions\nalembic_version\n:\nqueries\nquery_results\nquery_snippets\nusers\nvisualizations\nwidgets\nmetadata=# \\d queries\n## queries\n- schedule\n- updated_at\n- api_key\n- name\n- id\n- version\n- is_draft\n- query\n- is_archived\n- tags\n- last_modified_by_id\n- org_id\n- options\n- query_hash\n- description\n- latest_query_data_id\n- search_vector\n- data_source_id\n- schedule_failures\n- created_at\n- user_id\nmetadata=# \\d query_*\n## query_results\n- id\n- data\n- org_id\n- query_hash\n- data_source_id\n- runtime\n- query\n- retrieved_at\n## query_snippets\n- updated_at\n- id\n- description\n- created_at\n- user_id\n- trigger\n- snippet\n- org_id\n\n```\n\n#### execute query\n\nenter your SQL and semicolon.\n\n```bash\nmetadata=# select count(*) from queries;\n+-------+\n| count |\n+-------+\n|  3606 |\n+-------+\n\n1 row returned.\nTime: 0.0159s\n\n```\n\n`\\x` pivot result.\n\n\n\n```\nmetadata=# \\x\nset pivoted [True]\n\nmetadata=# select id, user_id from queries limit 3;\n-[RECORD 1]-------\n     id: 543\nuser_id: 40\n-[RECORD 2]-------\n     id: 717\nuser_id: 40\n-[RECORD 3]-------\n     id: 515\nuser_id: 38\n\n\n3 rows returned.\nTime: 0.0281s\n\n```\n\n### formats\n\nredasql support many formats. `\\f <format_name>` and `\\x`\n\n\n\n#### table format(default)\n\n```\nmetadata=# select id, object_id, org_id, created_at from favorites limit 3;\n\n+------+-------------+----------+--------------------------+\n|   id |   object_id |   org_id | created_at               |\n|------+-------------+----------+--------------------------|\n|    2 |         513 |        1 | 2019-05-22T05:30:17.185Z |\n|    3 |         514 |        1 | 2019-05-22T05:30:19.031Z |\n|    4 |         230 |        1 | 2019-05-22T08:17:12.693Z |\n+------+-------------+----------+--------------------------+\n\n3 rows returned.\nTime: 0.0219s\n```\n\n#### table format(pivoted)\n\n```\nmetadata=# select id, object_id, org_id, created_at from favorites limit 3;\n\n-[RECORD 1]----------\n        id| 2\n object_id| 513\n    org_id| 1\ncreated_at| 2019-05-22T05:30:17.185Z\n-[RECORD 2]----------\n        id| 3\n object_id| 514\n    org_id| 1\ncreated_at| 2019-05-22T05:30:19.031Z\n-[RECORD 3]----------\n        id| 4\n object_id| 230\n    org_id| 1\ncreated_at| 2019-05-22T08:17:12.693Z\n\n\n3 rows returned.\nTime: 0.0223s\n\n```\n\n#### markdown\n\n```\nmetadata=# \\f markdown\nset formatter [markdown]\nmetadata=# select id, object_id, org_id, created_at from favorites limit 3;\n\n|   id |   object_id |   org_id | created_at               |\n|------|-------------|----------|--------------------------|\n|    2 |         513 |        1 | 2019-05-22T05:30:17.185Z |\n|    3 |         514 |        1 | 2019-05-22T05:30:19.031Z |\n|    4 |         230 |        1 | 2019-05-22T08:17:12.693Z |\n\n3 rows returned.\nTime: 0.0207s\n\n```\n\n#### markdown(pivoted)\n\n\n```\nmetadata=# select id, object_id, org_id, created_at from favorites limit 3;\n\n| colum_name   | value                    |\n|--------------|--------------------------|\n| created_at   | 2019-05-22T05:30:17.185Z |\n| org_id       | 1                        |\n| id           | 2                        |\n| object_id    | 513                      |\n| created_at   | 2019-05-22T05:30:19.031Z |\n| org_id       | 1                        |\n| id           | 3                        |\n| object_id    | 514                      |\n| created_at   | 2019-05-22T08:17:12.693Z |\n| org_id       | 1                        |\n| id           | 4                        |\n| object_id    | 230                      |\n\n3 rows returned.\nTime: 0.0106s\n```\n\n#### markdown_with_sql\n\n```\n```sql\nselect id, object_id, org_id, created_at from favorites limit 3;\n``` .\n\n|   id |   object_id |   org_id | created_at               |\n|------|-------------|----------|--------------------------|\n|    2 |         513 |        1 | 2019-05-22T05:30:17.185Z |\n|    3 |         514 |        1 | 2019-05-22T05:30:19.031Z |\n|    4 |         230 |        1 | 2019-05-22T08:17:12.693Z |\n\n3 rows returned.\nTime: 0.0253s\n\n\n```\n\n#### csv\n\n```\nmetadata=# \\f csv\nset formatter [csv]\nmetadata=# select id, object_id, org_id, created_at from favorites limit 3;\n\nid,object_id,org_id,created_at\n2,513,1,2019-05-22T05:30:17.185Z\n3,514,1,2019-05-22T05:30:19.031Z\n4,230,1,2019-05-22T08:17:12.693Z\n\n```\n\n### run sqlfile\n\n`\\i` run local sqlfile.\n\n```\nmetadata=# \\i test.sql\nselect count(*) from queries;\n\n+---------+\n|   count |\n|---------|\n|    3876 |\n+---------+\n\n1 row returned.\nTime: 0.018s\n\n```\n\n### quit\n\n`ctrl + D` or `\\q` quit redasql.\n\n```\nmetadata=# \\q                                                                                                                                                                        \nSayonara!\n```\n\n### .redasqlrc\n\nif you create `~/.redasqlrc`, redasql reads the file at startup and performs initial settings.\n\n\n## Contribution\n\n### run test\n\n#### start up containers (redash, MySQL, postgresql)\n\nunittest necessary redash test server. use docker-compose.yml in `./tests/docker/v{REDAHS_VERSION}`\n\n - 8.0.2.b37747\n - 9.0.0-beta.b49509\n - 10.0.0.b50363\n\n```bash\n$ cd ./tests/docker/v8.0.2.b37747\n$ docker-compose up -d\n```\n\n#### run test\n\n```bash\n$ python -m unittest discover -s tests/\n```\n",
    'author': 'denzow',
    'author_email': 'denzow@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/denzow/redasql',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
