/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.CmdARQ;
import java.io.PrintStream;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.transaction.Journal;
import org.apache.jena.tdb.transaction.JournalControl;
import tdb.cmdline.ModLocation;

public class dumpjournal
extends CmdARQ {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLogging();
        new dumpjournal(argv).mainRun();
    }

    protected dumpjournal(String[] argv) {
        super(argv);
        super.addModule(this.modLocation);
    }

    @Override
    protected void exec() {
        Location loc = this.modLocation.getLocation();
        Journal journal = this.determineJournal(loc);
        this.dump(System.out, journal);
    }

    private void dump(PrintStream out, Journal journal) {
        JournalControl.print(journal);
    }

    private Journal determineJournal(Location loc) {
        if (!Journal.exists(loc)) {
            throw new CmdException("No journal file in " + loc);
        }
        return Journal.create(loc);
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }
}

