/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class infer
extends CmdGeneral {
    static final ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private Graph vocab;

    public static void main(String ... argv) {
        new infer(argv).mainRun();
    }

    protected infer(String[] argv) {
        super(argv);
        super.add(argRDFS);
    }

    @Override
    protected String getSummary() {
        return "infer --rdfs=vocab FILE ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!this.contains(argRDFS)) {
            throw new CmdException("Required argument missing: --" + argRDFS.getKeyName());
        }
        String fn = this.getValue(argRDFS);
        this.vocab = RDFDataMgr.loadGraph(fn);
    }

    @Override
    protected void exec() {
        StreamRDF sink = StreamRDFLib.writer(System.out);
        sink = RDFSFactory.streamRDFS(sink, this.vocab);
        List<String> files = this.getPositionalOrStdin();
        if (files.isEmpty()) {
            files.add("-");
        }
        for (String fn : files) {
            this.processFile(fn, sink);
        }
        IO.flush(System.out);
    }

    private void processFile(String filename, StreamRDF sink) {
        Lang lang;
        Lang lang2 = lang = filename.equals("-") ? RDFLanguages.NQUADS : RDFLanguages.filenameToLang(filename, RDFLanguages.NQUADS);
        if (filename.equals("-")) {
            RDFParser.source(System.in).lang(RDFLanguages.NQUADS).parse(sink);
        } else {
            RDFParser.source(filename).parse(sink);
        }
    }

    @Override
    protected String getCommandName() {
        return "infer";
    }
}

