/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene87;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene87.DeflateWithPresetDictCompressionMode;
import org.apache.lucene.codecs.lucene87.LZ4WithPresetDictCompressionMode;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class Lucene87StoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene87StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;
    private static final int BEST_COMPRESSION_BLOCK_LENGTH = 491520;
    public static final CompressionMode BEST_COMPRESSION_MODE = new DeflateWithPresetDictCompressionMode();
    private static final int BEST_SPEED_BLOCK_LENGTH = 81920;
    public static final CompressionMode BEST_SPEED_MODE = new LZ4WithPresetDictCompressionMode();

    public Lucene87StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene87StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context2) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Mode mode = Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context2);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context2) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + "old=" + previous + ", new=" + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context2);
    }

    StoredFieldsFormat impl(Mode mode) {
        switch (mode) {
            case BEST_SPEED: {
                return new CompressingStoredFieldsFormat("Lucene87StoredFieldsFastData", BEST_SPEED_MODE, 81920, 1024, 10);
            }
            case BEST_COMPRESSION: {
                return new CompressingStoredFieldsFormat("Lucene87StoredFieldsHighData", BEST_COMPRESSION_MODE, 491520, 4096, 10);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

