/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.jena.atlas.io.IO;

public class FileSender {
    private List<Entry> items = new ArrayList<Entry>();
    private String url;

    public FileSender(String url) {
        this.url = url;
    }

    public void add(String filename, String content, String type) {
        Entry e2 = new Entry();
        e2.fileName = filename;
        e2.content = content;
        e2.contentType = type;
        this.items.add(e2);
    }

    public void send(String method) {
        try {
            String WNL = "\r\n";
            String boundary = UUID.randomUUID().toString();
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setRequestMethod(method);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (PrintStream ps = new PrintStream(connection.getOutputStream());){
                for (Entry e2 : this.items) {
                    ps.print("--" + boundary + WNL);
                    ps.print("Content-Disposition: form-data; name=\"FILE\"; filename=\"" + e2.fileName + "\"" + WNL);
                    ps.print("Content-Type: " + e2.contentType + ";charset=UTF-8" + WNL);
                    ps.print(WNL);
                    ps.print(e2.content);
                    ps.print(WNL);
                }
                ps.print("--" + boundary + "--" + WNL);
            }
            connection.connect();
            int n = connection.getResponseCode();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    class Entry {
        String fileName;
        String content;
        String contentType;

        Entry() {
        }
    }
}

