/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.util.Map;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrReadonly;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.base.objectfile.ObjectFileReadonly;
import org.apache.jena.tdb.index.IndexParams;
import org.apache.jena.tdb.setup.BlockMgrBuilder;
import org.apache.jena.tdb.setup.DatasetBuilderStd;
import org.apache.jena.tdb.setup.ObjectFileBuilder;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.transaction.BlockMgrJournal;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.ObjectFileTrans;
import org.apache.jena.tdb.transaction.Transaction;
import org.apache.jena.tdb.transaction.TransactionManager;

public class DatasetBuilderTxn {
    private final TransactionManager txnMgr;
    private final Map<FileRef, BlockMgr> blockMgrs;
    private final Map<FileRef, ObjectFile> objectFiles;
    private final DatasetGraphTDB dsg;
    private Transaction txn;

    public DatasetBuilderTxn(TransactionManager txnMgr, DatasetGraphTDB dsg) {
        this.txnMgr = txnMgr;
        this.blockMgrs = dsg.getConfig().blockMgrs;
        this.objectFiles = dsg.getConfig().objectFiles;
        this.dsg = dsg;
    }

    DatasetGraphTxn build(Transaction txn, ReadWrite mode) {
        DatasetGraphTDB dsgTDB;
        this.txn = txn;
        switch (mode) {
            case READ: {
                dsgTDB = this.buildReadonly();
                break;
            }
            case WRITE: {
                dsgTDB = this.buildWritable();
                break;
            }
            default: {
                dsgTDB = null;
            }
        }
        DatasetGraphTxn dsgTxn = new DatasetGraphTxn(dsgTDB, txn);
        dsgTxn.getContext().putAll(this.dsg.getContext());
        return dsgTxn;
    }

    private DatasetGraphTDB buildReadonly() {
        BlockMgrBuilderReadonly blockMgrBuilder = new BlockMgrBuilderReadonly();
        ObjectFileBuilderReadonly objectFileBuilder = new ObjectFileBuilderReadonly();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, objectFileBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, false, this.dsg.getReorderTransform());
        return dsg2;
    }

    private DatasetGraphTDB buildWritable() {
        BlockMgrBuilderTx blockMgrBuilder = new BlockMgrBuilderTx();
        ObjectFileBuilderTx objectFileBuilder = new ObjectFileBuilderTx();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, objectFileBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, true, this.dsg.getReorderTransform());
        dsg2.getContext().putAll(this.dsg.getContext());
        return dsg2;
    }

    class ObjectFileBuilderReadonly
    implements ObjectFileBuilder {
        ObjectFileBuilderReadonly() {
        }

        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            FileRef ref = FileRef.create(fileSet, ext);
            ObjectFile file = DatasetBuilderTxn.this.objectFiles.get(ref);
            return new ObjectFileReadonly(file);
        }
    }

    class BlockMgrBuilderReadonly
    implements BlockMgrBuilder {
        BlockMgrBuilderReadonly() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr blockMgr = DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (blockMgr == null) {
                throw new TDBException("No BlockMgr for " + ref);
            }
            blockMgr = new BlockMgrReadonly(blockMgr);
            return blockMgr;
        }
    }

    class ObjectFileBuilderTx
    implements ObjectFileBuilder {
        ObjectFileBuilderTx() {
        }

        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            FileRef ref = FileRef.create(fileSet, ext);
            ObjectFile base = DatasetBuilderTxn.this.objectFiles.get(ref);
            ObjectFileTrans objFileTxn = new ObjectFileTrans(DatasetBuilderTxn.this.txn, base);
            DatasetBuilderTxn.this.txn.addComponent(objFileTxn);
            return objFileTxn;
        }
    }

    class BlockMgrBuilderTx
    implements BlockMgrBuilder {
        BlockMgrBuilderTx() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr baseMgr = DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (baseMgr == null) {
                System.out.println("No BlockMgr for " + ref + " : " + DatasetBuilderTxn.this.blockMgrs.keySet());
            }
            BlockMgrJournal blkMgr = new BlockMgrJournal(DatasetBuilderTxn.this.txn, ref, baseMgr);
            DatasetBuilderTxn.this.txn.addComponent(blkMgr);
            return blkMgr;
        }
    }
}

