/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;

public class Prologue {
    protected boolean seenBaseURI = false;
    protected PrefixMapping prefixMap = null;
    protected IRIxResolver resolver = null;

    public Prologue() {
        this(new PrefixMappingImpl(), null);
    }

    public Prologue(PrefixMapping pmap) {
        this(pmap, null);
    }

    public Prologue(PrefixMapping pmap, IRIxResolver resolver) {
        this.prefixMap = pmap;
        this.resolver = resolver;
    }

    public Prologue copy() {
        PrefixMappingImpl prefixMap = new PrefixMappingImpl();
        prefixMap.setNsPrefixes(this.prefixMap);
        return new Prologue(prefixMap, this.resolver);
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getBaseURI();
    }

    public IRIx getBase() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getBase();
    }

    public void setBase(IRIx base) {
        if (base == null) {
            this.resolver = null;
            return;
        }
        if (this.resolver == null) {
            this.resolver = IRIs.stdResolver();
        }
        this.resolver = this.resolver.resetBase(base);
    }

    public IRIxResolver getResolver() {
        return this.resolver;
    }

    public void setBaseURI(String baseURI) {
        if (baseURI == null) {
            this.seenBaseURI = false;
            this.resolver = null;
            return;
        }
        this.seenBaseURI = true;
        this.resolver = IRIxResolver.create(baseURI).build();
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            String oldExpansion = this.prefixMap.getNsPrefixURI(prefix);
            if (Objects.equals(oldExpansion, expansion)) {
                return;
            }
            if (oldExpansion != null) {
                this.prefixMap.removeNsPrefix(prefix);
            }
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            Log.warn(this, "Illegal prefix mapping(ignored): " + prefix + "=>" + expansion);
        }
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public String expandPrefixedName(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.prefixMap.getNsPrefixURI(prefix);
        if (uri == null) {
            return null;
        }
        return uri + prefixed.substring(colon + 1);
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }

    public boolean samePrologue(Prologue other) {
        String base2;
        String base1 = this.explicitlySetBaseURI() ? this.getBaseURI() : null;
        String string = base2 = other.explicitlySetBaseURI() ? other.getBaseURI() : null;
        if (!Objects.equals(base1, base2)) {
            return false;
        }
        if (this.getPrefixMapping() == null && other.getPrefixMapping() == null) {
            return true;
        }
        if (this.getPrefixMapping() == null) {
            return false;
        }
        return this.getPrefixMapping().samePrefixMappingAs(other.getPrefixMapping());
    }

    public static int hash(Prologue prologue) {
        int prime = 31;
        int x = 1;
        x = prologue.seenBaseURI ? 31 * x + prologue.getBaseURI().hashCode() : 1237;
        if (prologue.prefixMap != null) {
            x = 31 * x + prologue.prefixMap.getNsPrefixMap().hashCode();
        }
        return x;
    }
}

