/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public abstract class ShapeExpression {
    private static PrefixMap displayPrefixMap = PrefixMapFactory.createForOutput();
    public static NodeFormatter nodeFmtAbbrev;

    public abstract boolean satisfies(ValidationContext var1, Node var2);

    public abstract void print(IndentedWriter var1, NodeFormatter var2);

    public String asString() {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.setFlatMode(true);
        this.print(x, nodeFmtAbbrev);
        return x.asString();
    }

    public abstract void visit(ShapeExprVisitor var1);

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static {
        displayPrefixMap.add("owl", OWL.getURI());
        displayPrefixMap.add("rdf", RDF.getURI());
        displayPrefixMap.add("rdfs", RDFS.getURI());
        displayPrefixMap.add("xsd", XSD.getURI());
        nodeFmtAbbrev = new NodeFormatterTTL(null, displayPrefixMap);
    }
}

