/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.ShexException;

public enum NodeKind {
    IRI("IRI"),
    BNODE("BNode"),
    NONLITERAL("NonLiteral"),
    LITERAL("Literal"),
    TRIPLE("Triple");

    private final String label;

    private NodeKind(String string2) {
        this.label = string2;
    }

    public static NodeKind create(String nodeKind) {
        switch (nodeKind.toLowerCase()) {
            case "iri": {
                return IRI;
            }
            case "bnode": {
                return BNODE;
            }
            case "literal": {
                return LITERAL;
            }
            case "nonliteral": {
                return NONLITERAL;
            }
            case "triple": {
                return TRIPLE;
            }
        }
        throw new ShexException("NodeKind not recognized: '" + nodeKind + "'");
    }

    public String toString() {
        return this.label;
    }
}

