/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class QueryExecutionDatasetBuilder
implements QueryExecutionBuilder {
    private final QueryExecDatasetBuilder builder = QueryExecDatasetBuilder.create();
    private Dataset dataset = null;

    public static QueryExecutionDatasetBuilder create() {
        return new QueryExecutionDatasetBuilder();
    }

    @Override
    public QueryExecutionDatasetBuilder query(Query query2) {
        this.builder.query(query2);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder query(String queryString) {
        this.builder.query(queryString);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder query(String queryString, Syntax syntax) {
        this.builder.query(queryString, syntax);
        return this;
    }

    @Deprecated
    public QueryExecutionDatasetBuilder dataset(DatasetGraph dsg) {
        this.dataset = DatasetFactory.wrap(dsg);
        this.builder.dataset(dsg);
        return this;
    }

    public QueryExecutionDatasetBuilder dataset(Dataset dataset) {
        this.dataset = dataset;
        this.builder.dataset(dataset.asDatasetGraph());
        return this;
    }

    public QueryExecutionDatasetBuilder model(Model model) {
        Dataset ds = DatasetFactory.create(model);
        this.dataset(ds);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder set(Symbol symbol, Object value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder set(Symbol symbol, boolean value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder context(Context context2) {
        this.builder.context(context2);
        return this;
    }

    public QueryExecutionDatasetBuilder initialBinding(Binding binding) {
        this.builder.initialBinding(binding);
        return this;
    }

    public QueryExecutionDatasetBuilder initialBinding(QuerySolution querySolution) {
        if (querySolution != null) {
            Binding binding = BindingLib.toBinding(querySolution);
            this.initialBinding(binding);
        }
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder substitution(QuerySolution querySolution) {
        if (querySolution != null) {
            Binding binding = BindingLib.toBinding(querySolution);
            this.builder.substitution(binding);
        }
        return this;
    }

    public QueryExecutionDatasetBuilder substitution(Binding binding) {
        this.builder.substitution(binding);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder substitution(String varName, RDFNode value) {
        Var var = Var.alloc(varName);
        Node val = value.asNode();
        this.builder.substitution(var, val);
        return this;
    }

    @Override
    public QueryExecutionDatasetBuilder timeout(long value, TimeUnit timeUnit) {
        this.builder.timeout(value, timeUnit);
        return this;
    }

    public QueryExecutionDatasetBuilder initialTimeout(long value, TimeUnit timeUnit) {
        this.builder.initialTimeout(value, timeUnit);
        return this;
    }

    public QueryExecutionDatasetBuilder overallTimeout(long value, TimeUnit timeUnit) {
        this.builder.overallTimeout(value, timeUnit);
        return this;
    }

    @Override
    public QueryExecution build() {
        return QueryExecutionCompat.compatibility(this.builder, this.dataset, this.builder.getQuery(), this.builder.getQueryString());
    }

    public static Map<Var, Node> bindingToMap(Binding binding) {
        HashMap<Var, Node> substitutions = new HashMap<Var, Node>();
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = binding.get(v);
            substitutions.put(v, n);
        }
        return substitutions;
    }
}

