/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.system.Txn;

public class Backup {
    private static Set<DatasetGraph> activeBackups = Collections.newSetFromMap(new ConcurrentHashMap());

    public static String chooseFileName(String dsName) {
        String ds = dsName;
        if (ds.startsWith("/")) {
            ds = ds.substring(1);
        }
        if (ds.contains("/")) {
            Fuseki.adminLog.warn("Dataset name: weird format: " + dsName);
            ds = ds.replace("/", "_");
        }
        String timestamp = DateTimeUtils.nowAsString("yyyy-MM-dd_HH-mm-ss");
        Object filename = ds + "_" + timestamp;
        filename = FusekiWebapp.dirBackups.resolve((String)filename).toString();
        return filename;
    }

    public static void backup(Transactional transactional, DatasetGraph dsg, String backupfile) {
        if (transactional == null) {
            transactional = new TransactionalNull();
        }
        Txn.executeRead(transactional, () -> Backup.backup(dsg, backupfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backup(DatasetGraph dsg, String backupfile) {
        if (dsg == null) {
            throw new FusekiException("No dataset provided to backup");
        }
        if (!((String)backupfile).endsWith(".nq")) {
            backupfile = (String)backupfile + ".nq";
        }
        Set<DatasetGraph> set = activeBackups;
        synchronized (set) {
            if (activeBackups.contains(dsg)) {
                FmtLog.warn(Fuseki.serverLog, "Backup already in progress", new Object[0]);
            }
            activeBackups.add(dsg);
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream((String)backupfile + ".gz");
            out = new GZIPOutputStream(out, 8192);
            out = new BufferedOutputStream(out);
            RDFDataMgr.write(out, dsg, Lang.NQUADS);
            out.close();
            out = null;
        }
        catch (FileNotFoundException e2) {
            FmtLog.warn(Fuseki.serverLog, "File not found: %s", backupfile);
            throw new FusekiException("File not found: " + (String)backupfile);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            Set<DatasetGraph> set2 = activeBackups;
            synchronized (set2) {
                activeBackups.remove(dsg);
            }
        }
    }
}

