/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrTracker;
import org.apache.jena.ext.com.google.common.collect.HashMultiset;
import org.apache.jena.ext.com.google.common.collect.Multiset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTracker
implements BlockMgr {
    public static Logger logger = LoggerFactory.getLogger(BlockTracker.class);
    public static boolean collectHistory = true;
    static final Long NoId = -9L;
    protected final Multiset<Long> activeWriteBlocks = HashMultiset.create();
    protected final Multiset<Long> activeReadBlocks = HashMultiset.create();
    protected final List<Pair<Action, Long>> actions = new ArrayList<Pair<Action, Long>>();
    protected final BlockMgr blockMgr;
    private int inRead = 0;
    private int inUpdate = 0;
    private final Logger log;
    private final String label;

    private void clearBlockTracking() {
        this.activeReadBlocks.clear();
        this.activeWriteBlocks.clear();
        this.actions.clear();
    }

    public void clearHistory() {
        this.actions.clear();
    }

    public void clearAll() {
        this.clearBlockTracking();
    }

    public static BlockMgr track(BlockMgr blkMgr) {
        return BlockTracker.track(blkMgr.getLabel(), blkMgr);
    }

    private static BlockMgr track(String label, BlockMgr blkMgr) {
        return new BlockTracker(label, blkMgr);
    }

    private BlockTracker(BlockMgr blockMgr) {
        this(LoggerFactory.getLogger(BlockMgrTracker.class), blockMgr.getLabel(), blockMgr);
    }

    private BlockTracker(String label, BlockMgr blockMgr) {
        this(logger, label, blockMgr);
    }

    private BlockTracker(Logger logger, String label, BlockMgr blockMgr) {
        this.blockMgr = blockMgr;
        this.log = logger;
        this.label = blockMgr.getLabel();
    }

    private void add(Action action, Long id) {
        if (collectHistory) {
            this.actions.add(new Pair<Action, Long>(action, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block allocate(int blockSize) {
        Block block;
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Alloc);
            block = this.blockMgr.allocate(blockSize);
            Long id = block.getId();
            this.activeWriteBlocks.add(id);
            this.add(Action.Alloc, id);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getRead(long id) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkRead(Action.GetRead);
            Long x = id;
            this.add(Action.GetRead, x);
            if (this.activeWriteBlocks.contains(x)) {
                this.activeWriteBlocks.add(x);
            } else {
                this.activeReadBlocks.add(x);
            }
        }
        return this.blockMgr.getRead(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getWrite(long id) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.GetWrite);
            Long x = id;
            this.add(Action.GetWrite, x);
            this.activeWriteBlocks.add(x);
        }
        return this.blockMgr.getWrite(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block promote(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Promote);
            Long id = block.getId();
            this.add(Action.Promote, id);
            if (!this.activeWriteBlocks.contains(id) && !this.activeReadBlocks.contains(id)) {
                this.error(Action.Promote, id + " is not an active block");
            }
            while (this.activeReadBlocks.contains(id)) {
                this.activeReadBlocks.remove(id);
            }
            if (!this.activeWriteBlocks.contains(id)) {
                this.activeWriteBlocks.add(id);
            }
        }
        return this.blockMgr.promote(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            Long id = block.getId();
            this.add(Action.Release, id);
            if (this.activeWriteBlocks.contains(id)) {
                this.activeWriteBlocks.remove(id);
            } else {
                this.activeReadBlocks.remove(block.getId());
            }
        }
        this.blockMgr.release(block);
    }

    @Override
    public void write(Block block) {
        if (logger.isInfoEnabled() && block.getId() == 2L) {
            this.debugPoint();
        }
        this.writeTracker(block);
        this.blockMgr.write(block);
    }

    @Override
    public synchronized void overwrite(Block block) {
        this.writeTracker(block);
        this.blockMgr.overwrite(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTracker(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Write);
            Long id = block.getId();
            this.add(Action.Write, id);
            if (!this.activeWriteBlocks.contains(id)) {
                this.error(Action.Write, id + " is not an active write block");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Block block) {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            this.checkUpdate(Action.Free);
            Long id = block.getId();
            this.add(Action.Free, id);
            if (this.activeReadBlocks.contains(id)) {
                this.warn(Action.Free, id + " is a read block");
            }
            if (!this.activeWriteBlocks.contains(id)) {
                this.error(Action.Free, id + " is not a write block");
            }
            this.activeWriteBlocks.remove(id);
            if (this.activeWriteBlocks.count(id) != 0) {
                this.warn(Action.Free, id + " has " + this.activeWriteBlocks.count(id) + " outstanding write registrations");
            }
        }
        this.blockMgr.free(block);
    }

    @Override
    public void sync() {
        this.blockMgr.sync();
    }

    @Override
    public void syncForce() {
        this.blockMgr.syncForce();
    }

    @Override
    public void close() {
        this.blockMgr.close();
    }

    @Override
    public boolean isEmpty() {
        return this.blockMgr.isEmpty();
    }

    @Override
    public long allocLimit() {
        return this.blockMgr.allocLimit();
    }

    @Override
    public void resetAlloc(long boundary) {
        this.blockMgr.resetAlloc(boundary);
    }

    @Override
    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    @Override
    public boolean isClosed() {
        return this.blockMgr.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void beginRead() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inUpdate != 0) {
                this.error(Action.BeginRead, "beginRead when already in update");
            }
            ++this.inRead;
        }
        this.blockMgr.beginRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void endRead() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inRead == 0) {
                this.error(Action.EndRead, "endRead but not in read");
            }
            if (this.inUpdate != 0) {
                this.error(Action.EndRead, "endRead when in update");
            }
            this.checkEmpty("Outstanding write blocks at end of read operations!", this.activeWriteBlocks);
            if (this.inRead == 0) {
                this.checkEmpty("Outstanding read blocks at end of read operations", this.activeReadBlocks);
                this.clearBlockTracking();
            }
            --this.inRead;
        }
        this.blockMgr.endRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginUpdate() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inRead > 0) {
                this.error(Action.BeginUpdate, "beginUpdate when already in read");
            }
            if (this.inUpdate > 0) {
                this.error(Action.BeginUpdate, "beginUpdate when already in update");
            }
            ++this.inUpdate;
            this.clearBlockTracking();
        }
        this.blockMgr.beginUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endUpdate() {
        BlockTracker blockTracker = this;
        synchronized (blockTracker) {
            if (this.inUpdate == 0) {
                this.error(Action.EndUpdate, "endUpdate but not in update");
            }
            if (this.inRead > 0) {
                this.error(Action.EndUpdate, "endUpdate when in read");
            }
            this.checkEmpty("Outstanding read blocks at end of update operations", this.activeReadBlocks);
            this.checkEmpty("Outstanding write blocks at end of update operations", this.activeWriteBlocks);
            --this.inUpdate;
            this.clearBlockTracking();
        }
        this.blockMgr.endUpdate();
    }

    private void checkUpdate(Action action) {
        if (this.inUpdate == 0) {
            this.error(action, "called outside update");
        }
    }

    private void checkRead(Action action) {
        if (this.inUpdate == 0 && this.inRead == 0) {
            this.error(action, "Called outside update and read");
        }
    }

    private void checkEmpty(String string, Multiset<Long> blocks) {
        if (!blocks.isEmpty()) {
            this.error(string);
            for (Long id : blocks) {
                this.warn("    Block: " + id);
            }
            if (collectHistory) {
                this.history();
            }
            throw new DBOpEnvException();
        }
    }

    private String msg(String string) {
        if (this.label == null) {
            return string;
        }
        return this.label + ": " + string;
    }

    private void info(String string) {
        this.log.info(this.msg(string));
    }

    private void warn(String string) {
        this.log.warn(this.msg(string));
    }

    private void warn(Action action, String string) {
        this.warn(action + ": " + string);
    }

    private void error(String string) {
        this.log.error(this.msg(string));
    }

    private void error(Action action, String string) {
        this.error(action + ": " + string);
        this.history();
        throw new BlockException(this.msg(action + ": " + string));
    }

    private void debugPoint() {
    }

    private void history() {
        this.info("History");
        for (Pair<Action, Long> p : this.actions) {
            if (p.getRight() != NoId) {
                this.log.info(String.format("%s:     %-12s  %d", new Object[]{this.label, p.getLeft(), p.getRight()}));
                continue;
            }
            this.log.info(String.format("%s:     %-12s", new Object[]{this.label, p.getLeft()}));
        }
    }

    public String toString() {
        return "BlockMgrTracker" + (String)(this.label == null ? "" : ": " + this.label);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    static enum Action {
        Alloc,
        Promote,
        GetRead,
        GetWrite,
        Write,
        Release,
        Free,
        BeginIter,
        EndIter,
        IterRead,
        BeginRead,
        EndRead,
        BeginUpdate,
        EndUpdate;

    }
}

