/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext;

import edu.rpi.tw.jena.query.fulltext.DatasetGraphText;
import edu.rpi.tw.jena.query.fulltext.TextHit;
import edu.rpi.tw.jena.query.fulltext.TextIndex;
import edu.rpi.tw.jena.query.fulltext.TextIndexException;
import edu.rpi.tw.jena.query.fulltext.TextQuery;
import edu.rpi.tw.jena.query.fulltext.TextQueryFuncs;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.com.google.common.base.Strings;
import org.apache.jena.ext.com.google.common.collect.LinkedListMultimap;
import org.apache.jena.ext.com.google.common.collect.ListMultimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex textIndex = null;
    private boolean warningIssued = false;
    private static final Symbol cacheSymbol = Symbol.create((String)"TextQueryPF.cache");
    private static final int CACHE_SIZE = 10;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        List list;
        int sz;
        int size;
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.textIndex = TextQueryPF.chooseTextIndex(execCxt, dsg);
        if (argSubject.isList() && ((size = argSubject.getArgListSize()) == 0 || size > 2)) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, must be at least 1 and not greater than 2: " + argSubject);
        }
        if (argObject.isList() && (sz = (list = argObject.getArgList()).size()) == 0) {
            throw new QueryBuildException("Zero-length argument list");
        }
    }

    private static TextIndex chooseTextIndex(ExecutionContext execCxt, DatasetGraph dsg) {
        Object obj = execCxt.getContext().get(TextQuery.textIndex);
        if (obj != null) {
            try {
                return (TextIndex)obj;
            }
            catch (ClassCastException ex) {
                Log.warn(TextQueryPF.class, (String)("Context setting '" + obj.toString() + "'is not a TextIndex"));
            }
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        Log.warn(TextQueryPF.class, (String)"Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    private String extractArg(String prefix, List<Node> objArgs) {
        String value = null;
        for (Node node : objArgs) {
            String arg;
            if (!node.isLiteral() || !(arg = node.getLiteral().toString()).startsWith(prefix + ":")) continue;
            value = arg.substring(prefix.length() + 1);
            break;
        }
        return value;
    }

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (log.isTraceEnabled()) {
            IndentedLineBuffer subjBuff = new IndentedLineBuffer();
            argSubject.output((IndentedWriter)subjBuff, null);
            IndentedLineBuffer objBuff = new IndentedLineBuffer();
            argObject.output((IndentedWriter)objBuff, null);
            log.trace("exec: {} text:query {}", (Object)subjBuff, (Object)objBuff);
        }
        if (this.textIndex == null) {
            if (!this.warningIssued) {
                Log.warn(((Object)((Object)this)).getClass(), (String)"No text index - no text search performed");
                this.warningIssued = true;
            }
            return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
        }
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        Node score = null;
        Node literal = null;
        Node graph = null;
        if (argSubject.isList()) {
            literal = argSubject.getArg(0);
            if (argSubject.getArgListSize() > 1 && !(score = argSubject.getArg(1)).isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + argSubject);
            }
        } else {
            literal = argSubject.getArg();
        }
        if (literal.isLiteral()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        StrMatch match = this.objectToStruct(argObject, true);
        if (match == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        QueryIterator qIter = this.prepareQuery(binding, literal, score, graph, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, (long)match.getLimit(), execCxt);
        }
        return qIter;
    }

    private static void addIf(BindingBuilder bmap, Var var, Node node) {
        if (var != null && node != null) {
            bmap.add(var, node);
        }
    }

    private QueryIterator resultsToQueryIterator(Binding binding, Node literal, Node score, Node graph, Collection<TextHit> results, ExecutionContext execCxt) {
        log.trace("resultsToQueryIterator CALLED with results: {}", results);
        Var scoreVar = score == null ? null : Var.alloc((Node)score);
        Var literalVar = literal == null ? null : Var.alloc((Node)literal);
        Function<TextHit, Binding> converter = hit -> {
            if (score == null) {
                return literalVar != null ? BindingFactory.binding((Binding)binding, (Var)literalVar, (Node)hit.getLiteral()) : BindingFactory.binding((Binding)binding);
            }
            BindingBuilder bmap = Binding.builder((Binding)binding);
            TextQueryPF.addIf(bmap, literalVar, hit.getLiteral());
            TextQueryPF.addIf(bmap, scoreVar, NodeFactoryExtra.floatToNode((float)hit.getScore()));
            log.trace("resultsToQueryIterator RETURNING bmap: {}", (Object)bmap);
            return bmap.build();
        };
        Iterator bIter = Iter.map(results.iterator(), converter);
        QueryIterator qIter = QueryIterPlainWrapper.create((Iterator)bIter, (ExecutionContext)execCxt);
        return qIter;
    }

    private QueryIterator prepareQuery(Binding binding, Node literal, Node score, Node graph, StrMatch match, ExecutionContext execCxt) {
        log.trace("prepareQuery with params: {}", (Object)match);
        ListMultimap<String, TextHit> rezList = this.query(match, execCxt);
        if (rezList == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        Collection hits = rezList.values();
        return this.resultsToQueryIterator(binding, literal, score, graph, hits, execCxt);
    }

    private ListMultimap<String, TextHit> query(StrMatch match, ExecutionContext execCxt) {
        String graphURI = this.chooseGraphURI(execCxt);
        String qs = match.getQueryString();
        int limit = match.getQueryLimit();
        String lang = match.getLang();
        String highlight = match.getHighlight();
        this.explainQuery(qs, limit, execCxt, graphURI);
        if (this.textIndex.getDocDef().areQueriesCached()) {
            String cacheKey = limit + "  " + qs + " " + lang + " " + graphURI;
            Cache<String, ListMultimap<String, TextHit>> queryCache = this.prepareCache(execCxt);
            log.trace("Caching Text query: {} with key: >>{}<< in cache: {}", new Object[]{qs, cacheKey, queryCache});
            return (ListMultimap)queryCache.getOrFill((Object)cacheKey, () -> this.performQuery(match, qs, graphURI, lang, limit, highlight));
        }
        log.trace("Executing w/o cache Text query: {}", (Object)qs);
        return this.performQuery(match, qs, graphURI, lang, limit, highlight);
    }

    private Cache<String, ListMultimap<String, TextHit>> prepareCache(ExecutionContext execCxt) {
        Cache queryCache = (Cache)execCxt.getContext().get(cacheSymbol);
        if (queryCache == null) {
            queryCache = CacheFactory.createCache((int)10);
            execCxt.getContext().put(cacheSymbol, (Object)queryCache);
        }
        return queryCache;
    }

    private void explainQuery(String queryString, int limit, ExecutionContext execCxt, String graphURI) {
        if (graphURI == null) {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query: " + queryString));
            log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
        } else {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query <" + graphURI + ">: " + queryString));
            log.debug("Text query: {} <{}> ({})", new Object[]{queryString, graphURI, limit});
        }
    }

    private String chooseGraphURI(ExecutionContext execCxt) {
        NamedGraph namedGraph;
        String graphURI = null;
        Graph activeGraph = execCxt.getActiveGraph();
        if (this.textIndex.getDocDef().getGraphField() != null && activeGraph instanceof NamedGraph && !Quad.isUnionGraph((Node)(namedGraph = (NamedGraph)activeGraph).getGraphName())) {
            graphURI = namedGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(namedGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
        }
        return graphURI;
    }

    private ListMultimap<String, TextHit> performQuery(StrMatch match, String queryString, String graphURI, String lang, int limit, String highlight) {
        List<TextHit> resultList = null;
        resultList = this.textIndex.query(queryString, graphURI, lang, limit, highlight);
        return this.mapResult(resultList);
    }

    private ListMultimap<String, TextHit> mapResult(List<TextHit> resultList) {
        LinkedListMultimap results = LinkedListMultimap.create();
        for (TextHit result : resultList) {
            results.put((Object)result.getLiteral().getLiteralLexicalForm(), (Object)result);
        }
        return results;
    }

    private StrMatch objectToStruct(PropFuncArg argObject, boolean executionTime) {
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                if (executionTime) {
                    log.warn("Object to text:search is not a literal " + argObject);
                }
                return null;
            }
            String lang = o.getLiteralLanguage();
            RDFDatatype dt = o.getLiteralDatatype();
            if (lang.isEmpty() && dt != null && dt != XSDDatatype.XSDstring) {
                log.warn("Object to text query is not a string");
                return null;
            }
            lang = Strings.emptyToNull((String)lang);
            String qs = o.getLiteralLexicalForm();
            return new StrMatch(qs, lang, -1, 0.0f, null);
        }
        List list = argObject.getArgList();
        if (list.size() == 0) {
            throw new TextIndexException("text:search object list can not be empty");
        }
        int idx = 0;
        Node x = (Node)list.get(idx);
        if (!x.isLiteral()) {
            if (executionTime) {
                log.warn("Text query string is not a literal " + list + " AT idx: " + idx);
            }
            return null;
        }
        String lang = x.getLiteralLanguage();
        if (lang.isEmpty() && x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            log.warn("Text query is not a string " + list);
            return null;
        }
        lang = Strings.emptyToNull((String)lang);
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            ++idx;
            if (!x.isLiteral()) {
                if (executionTime) {
                    log.warn("Text query limit is not an integer " + x);
                }
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            limit = v < 0 ? -1 : v;
        }
        String string = lang = lang == null ? this.extractArg("lang", list) : lang;
        if (lang != null && this.textIndex.getDocDef().getLangField() == null) {
            log.warn("lang argument is ignored if langField not set in the index configuration");
        }
        String highlight = this.extractArg("highlight", list);
        return new StrMatch(queryString, lang, limit, score, highlight);
    }

    class StrMatch {
        private final String queryString;
        private final String lang;
        private final int limit;
        private int queryLimit;
        private final float scoreLimit;
        private final String highlight;

        public StrMatch(String queryString, String lang, int limit, float scoreLimit, String highlight) {
            this.queryString = queryString;
            this.lang = lang;
            this.limit = limit;
            this.queryLimit = limit;
            this.scoreLimit = scoreLimit;
            this.highlight = highlight;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getLang() {
            return this.lang;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setQueryLimit(int qLimit) {
            this.queryLimit = qLimit;
        }

        public int getQueryLimit() {
            return this.queryLimit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }

        public String getHighlight() {
            return this.highlight;
        }

        public String toString() {
            return "( query: " + this.queryString + "; limit: " + this.limit + "; lang: " + this.lang + "; highlight: " + this.highlight + " )";
        }
    }
}

