"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import qwak.models.models_pb2
import qwak.projects.jfrog_project_spec_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CreateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_NAME_FIELD_NUMBER: builtins.int
    PROJECT_DESCRIPTION_FIELD_NUMBER: builtins.int
    JFROG_SPEC_FIELD_NUMBER: builtins.int
    project_name: builtins.str
    """Project name to create"""
    project_description: builtins.str
    """Project description"""
    @property
    def jfrog_spec(self) -> qwak.projects.jfrog_project_spec_pb2.ModelRepositoryJFrogSpec:
        """jfrog spec"""
    def __init__(
        self,
        *,
        project_name: builtins.str = ...,
        project_description: builtins.str = ...,
        jfrog_spec: qwak.projects.jfrog_project_spec_pb2.ModelRepositoryJFrogSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["jfrog_spec", b"jfrog_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["jfrog_spec", b"jfrog_spec", "project_description", b"project_description", "project_name", b"project_name"]) -> None: ...

global___CreateProjectRequest = CreateProjectRequest

class CreateProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def project(self) -> global___ProjectSpec:
        """Info about the creation process"""
    def __init__(
        self,
        *,
        project: global___ProjectSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project", b"project"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project"]) -> None: ...

global___CreateProjectResponse = CreateProjectResponse

class ListProjectsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListProjectsRequest = ListProjectsRequest

class ListProjectsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECTS_FIELD_NUMBER: builtins.int
    @property
    def projects(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProjectSpec]:
        """List of projects"""
    def __init__(
        self,
        *,
        projects: collections.abc.Iterable[global___ProjectSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["projects", b"projects"]) -> None: ...

global___ListProjectsResponse = ListProjectsResponse

class GetProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Id of the project to get"""
    project_name: builtins.str
    """Name of the project to get"""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        project_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id", "project_name", b"project_name"]) -> None: ...

global___GetProjectRequest = GetProjectRequest

class GetProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def project(self) -> global___Project:
        """The project object"""
    def __init__(
        self,
        *,
        project: global___Project | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project", b"project"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project"]) -> None: ...

global___GetProjectResponse = GetProjectResponse

class DeleteProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """Id of the project to delete"""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___DeleteProjectRequest = DeleteProjectRequest

class DeleteProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INFO_FIELD_NUMBER: builtins.int
    info: builtins.str
    """Info about the deleting process"""
    def __init__(
        self,
        *,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info"]) -> None: ...

global___DeleteProjectResponse = DeleteProjectResponse

class UpdateProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_SPEC_CONFIG_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project id to update"""
    @property
    def project_spec_config(self) -> global___ProjectSpecConfiguration:
        """The project specification to update"""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        project_spec_config: global___ProjectSpecConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project_spec_config", b"project_spec_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id", "project_spec_config", b"project_spec_config"]) -> None: ...

global___UpdateProjectRequest = UpdateProjectRequest

class UpdateProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_SPEC_FIELD_NUMBER: builtins.int
    @property
    def project_spec(self) -> global___ProjectSpec:
        """The updated project specification"""
    def __init__(
        self,
        *,
        project_spec: global___ProjectSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project_spec", b"project_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_spec", b"project_spec"]) -> None: ...

global___UpdateProjectResponse = UpdateProjectResponse

class Project(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEC_FIELD_NUMBER: builtins.int
    MODELS_FIELD_NUMBER: builtins.int
    MODELS_BRIEFS_FIELD_NUMBER: builtins.int
    @property
    def spec(self) -> global___ProjectSpec:
        """The project specification"""
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.models.models_pb2.Model]:
        """List of models owned by the project"""
    @property
    def models_briefs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.models.models_pb2.ModelBrief]:
        """List of models owned by the project"""
    def __init__(
        self,
        *,
        spec: global___ProjectSpec | None = ...,
        models: collections.abc.Iterable[qwak.models.models_pb2.Model] | None = ...,
        models_briefs: collections.abc.Iterable[qwak.models.models_pb2.ModelBrief] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "models_briefs", b"models_briefs", "spec", b"spec"]) -> None: ...

global___Project = Project

class ProjectSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ProjectSpec._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: ProjectSpec._Status.ValueType  # 0
        DISABLED: ProjectSpec._Status.ValueType  # 1
        SUSPENDED: ProjectSpec._Status.ValueType  # 2
        ACTIVE: ProjectSpec._Status.ValueType  # 3

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Project Status
        Active - Live active project
        Suspended - Suspended project
        Disabled - Deleted Project
        """

    INVALID: ProjectSpec.Status.ValueType  # 0
    DISABLED: ProjectSpec.Status.ValueType  # 1
    SUSPENDED: ProjectSpec.Status.ValueType  # 2
    ACTIVE: ProjectSpec.Status.ValueType  # 3

    PROJECT_ID_FIELD_NUMBER: builtins.int
    PROJECT_NAME_FIELD_NUMBER: builtins.int
    PROJECT_DESCRIPTION_FIELD_NUMBER: builtins.int
    PROJECT_STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_BY_FIELD_NUMBER: builtins.int
    MODELS_COUNT_FIELD_NUMBER: builtins.int
    MODELS_ACTIVE_FIELD_NUMBER: builtins.int
    JFROG_SETTINGS_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The project id"""
    project_name: builtins.str
    """The project name"""
    project_description: builtins.str
    """Description of the project"""
    project_status: global___ProjectSpec.Status.ValueType
    """Project Status"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of creation"""
    created_by: builtins.str
    """UserId that created the project"""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Last modified timestamp the project"""
    last_modified_by: builtins.str
    """Last modified userId"""
    models_count: builtins.int
    """Count of active(status not disabled) models in the project"""
    models_active: builtins.int
    """Count of deployed models in the project"""
    @property
    def jfrog_settings(self) -> global___ModelRepositoryJFrogSettings:
        """Jfrog model repository settings"""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        project_name: builtins.str = ...,
        project_description: builtins.str = ...,
        project_status: global___ProjectSpec.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_by: builtins.str = ...,
        models_count: builtins.int = ...,
        models_active: builtins.int = ...,
        jfrog_settings: global___ModelRepositoryJFrogSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "jfrog_settings", b"jfrog_settings", "last_modified_at", b"last_modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "jfrog_settings", b"jfrog_settings", "last_modified_at", b"last_modified_at", "last_modified_by", b"last_modified_by", "models_active", b"models_active", "models_count", b"models_count", "project_description", b"project_description", "project_id", b"project_id", "project_name", b"project_name", "project_status", b"project_status"]) -> None: ...

global___ProjectSpec = ProjectSpec

class ProjectSpecConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_NAME_FIELD_NUMBER: builtins.int
    PROJECT_DESCRIPTION_FIELD_NUMBER: builtins.int
    project_name: builtins.str
    """The project name"""
    project_description: builtins.str
    """Description of the project"""
    def __init__(
        self,
        *,
        project_name: builtins.str = ...,
        project_description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_description", b"project_description", "project_name", b"project_name"]) -> None: ...

global___ProjectSpecConfiguration = ProjectSpecConfiguration

class ModelRepositoryJFrogSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PULL_IMAGE_SECRET_FIELD_NUMBER: builtins.int
    JFROG_PROJECT_DETAILS_FIELD_NUMBER: builtins.int
    JFROG_REPOSITORIES_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def pull_image_secret(self) -> global___ModelRepositoryPullImageSecret:
        """jfrog image pull secret info"""
    @property
    def jfrog_project_details(self) -> global___ModelRepositoryJFrogProjectDetails:
        """jfrog project details"""
    @property
    def jfrog_repositories_details(self) -> global___ModelRepositoryArtifactoryDetails:
        """jfrog repositories details"""
    def __init__(
        self,
        *,
        pull_image_secret: global___ModelRepositoryPullImageSecret | None = ...,
        jfrog_project_details: global___ModelRepositoryJFrogProjectDetails | None = ...,
        jfrog_repositories_details: global___ModelRepositoryArtifactoryDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["jfrog_project_details", b"jfrog_project_details", "jfrog_repositories_details", b"jfrog_repositories_details", "pull_image_secret", b"pull_image_secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["jfrog_project_details", b"jfrog_project_details", "jfrog_repositories_details", b"jfrog_repositories_details", "pull_image_secret", b"pull_image_secret"]) -> None: ...

global___ModelRepositoryJFrogSettings = ModelRepositoryJFrogSettings

class ModelRepositoryPullImageSecret(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PULL_IMAGE_SECRET_NAME_FIELD_NUMBER: builtins.int
    pull_image_secret_name: builtins.str
    """The pull image secret name"""
    def __init__(
        self,
        *,
        pull_image_secret_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pull_image_secret_name", b"pull_image_secret_name"]) -> None: ...

global___ModelRepositoryPullImageSecret = ModelRepositoryPullImageSecret

class ModelRepositoryJFrogProjectDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JFROG_PROJECT_KEY_FIELD_NUMBER: builtins.int
    jfrog_project_key: builtins.str
    """The jfrog project key"""
    def __init__(
        self,
        *,
        jfrog_project_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["jfrog_project_key", b"jfrog_project_key"]) -> None: ...

global___ModelRepositoryJFrogProjectDetails = ModelRepositoryJFrogProjectDetails

class ModelRepositoryArtifactoryDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACT_REPOSITORY_DETAILS_FIELD_NUMBER: builtins.int
    DATASET_REPOSITORY_DETAILS_FIELD_NUMBER: builtins.int
    DOCKER_REPOSITORY_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def artifact_repository_details(self) -> global___ArtifactoryRepositoryDetails:
        """The jfrog artifact repository details"""
    @property
    def dataset_repository_details(self) -> global___ArtifactoryRepositoryDetails:
        """The jfrog dataset repository details"""
    @property
    def docker_repository_details(self) -> global___ArtifactoryRepositoryDetails:
        """The jfrog docker repository details"""
    def __init__(
        self,
        *,
        artifact_repository_details: global___ArtifactoryRepositoryDetails | None = ...,
        dataset_repository_details: global___ArtifactoryRepositoryDetails | None = ...,
        docker_repository_details: global___ArtifactoryRepositoryDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["artifact_repository_details", b"artifact_repository_details", "dataset_repository_details", b"dataset_repository_details", "docker_repository_details", b"docker_repository_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_repository_details", b"artifact_repository_details", "dataset_repository_details", b"dataset_repository_details", "docker_repository_details", b"docker_repository_details"]) -> None: ...

global___ModelRepositoryArtifactoryDetails = ModelRepositoryArtifactoryDetails

class ArtifactoryRepositoryDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_KEY_FIELD_NUMBER: builtins.int
    repository_key: builtins.str
    """The repository key"""
    def __init__(
        self,
        *,
        repository_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["repository_key", b"repository_key"]) -> None: ...

global___ArtifactoryRepositoryDetails = ArtifactoryRepositoryDetails
