"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import qwak.execution.v1.backfill_pb2
import qwak.kube_deployment_captain.alert_pb2
import qwak.kube_deployment_captain.alerting_pb2
import qwak.kube_deployment_captain.deployment_pb2
import qwak.kube_deployment_captain.feature_set_deployment_pb2
import qwak.kube_deployment_captain.traffic_mapping_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _KubeModelDeploymentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _KubeModelDeploymentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KubeModelDeploymentStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_STATUS: _KubeModelDeploymentStatus.ValueType  # 0
    """Invalid status"""
    PENDING_DEPLOYMENT: _KubeModelDeploymentStatus.ValueType  # 2
    """Deployment is in progress"""
    SUCCESSFUL_DEPLOYMENT: _KubeModelDeploymentStatus.ValueType  # 3
    """Deployment has finished successfully"""
    FAILED_DEPLOYMENT: _KubeModelDeploymentStatus.ValueType  # 4
    """Deployment has failed"""
    SUCCESSFUL_UNDEPLOYMENT: _KubeModelDeploymentStatus.ValueType  # 5
    """Model is undeployed"""
    FAILED_UNDEPLOYMENT: _KubeModelDeploymentStatus.ValueType  # 6
    """Model is undeployed"""

class KubeModelDeploymentStatus(_KubeModelDeploymentStatus, metaclass=_KubeModelDeploymentStatusEnumTypeWrapper): ...

INVALID_STATUS: KubeModelDeploymentStatus.ValueType  # 0
"""Invalid status"""
PENDING_DEPLOYMENT: KubeModelDeploymentStatus.ValueType  # 2
"""Deployment is in progress"""
SUCCESSFUL_DEPLOYMENT: KubeModelDeploymentStatus.ValueType  # 3
"""Deployment has finished successfully"""
FAILED_DEPLOYMENT: KubeModelDeploymentStatus.ValueType  # 4
"""Deployment has failed"""
SUCCESSFUL_UNDEPLOYMENT: KubeModelDeploymentStatus.ValueType  # 5
"""Model is undeployed"""
FAILED_UNDEPLOYMENT: KubeModelDeploymentStatus.ValueType  # 6
"""Model is undeployed"""
global___KubeModelDeploymentStatus = KubeModelDeploymentStatus

class ApplyModelsAlertsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    ALERTS_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    MODEL_LINK_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID to deploy the model under"""
    @property
    def alerts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.kube_deployment_captain.alert_pb2.KubeAlertRule]:
        """The alerts list for model"""
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to apply alert"""
    model_link: builtins.str
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        alerts: collections.abc.Iterable[qwak.kube_deployment_captain.alert_pb2.KubeAlertRule] | None = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        model_link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["alerts", b"alerts", "branch_id", b"branch_id", "kube_deployment_type", b"kube_deployment_type", "model_id", b"model_id", "model_link", b"model_link"]) -> None: ...

global___ApplyModelsAlertsRequest = ApplyModelsAlertsRequest

class CreateOrReplaceFeatureSetAlertRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> qwak.kube_deployment_captain.alerting_pb2.FeatureSetAlertOptions:
        """Parameters for creating or replacing an alert"""
    def __init__(
        self,
        *,
        options: qwak.kube_deployment_captain.alerting_pb2.FeatureSetAlertOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["options", b"options"]) -> None: ...

global___CreateOrReplaceFeatureSetAlertRequest = CreateOrReplaceFeatureSetAlertRequest

class DeleteFeatureSetAlertRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> qwak.kube_deployment_captain.alerting_pb2.FeatureSetAlertOptions:
        """Parameters for deleting an alert"""
    def __init__(
        self,
        *,
        options: qwak.kube_deployment_captain.alerting_pb2.FeatureSetAlertOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["options", b"options"]) -> None: ...

global___DeleteFeatureSetAlertRequest = DeleteFeatureSetAlertRequest

class DeleteFeatureSetAlertResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteFeatureSetAlertResponse = DeleteFeatureSetAlertResponse

class CreateOrReplaceFeatureSetFailureResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CreateOrReplaceFeatureSetFailureResponse = CreateOrReplaceFeatureSetFailureResponse

class ApplyModelsAlertsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ApplyModelsAlertsResponse = ApplyModelsAlertsResponse

class CleanStorageObjectFromCloudStorageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    FAILURE_REASON_FIELD_NUMBER: builtins.int
    success: builtins.bool
    """Whether the request was successful or not"""
    failure_reason: builtins.str
    """The failure description"""
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        failure_reason: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["failure_reason", b"failure_reason", "success", b"success"]) -> None: ...

global___CleanStorageObjectFromCloudStorageResponse = CleanStorageObjectFromCloudStorageResponse

class KubeDeployModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentVariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    DOCKER_IMAGE_FIELD_NUMBER: builtins.int
    NUMBER_OF_PODS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SIZE_FIELD_NUMBER: builtins.int
    ADVANCED_DEPLOYMENT_OPTIONS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    SERVING_STRATEGY_FIELD_NUMBER: builtins.int
    ENVIRONMENT_VARIABLES_FIELD_NUMBER: builtins.int
    AUTO_SCALING_SPEC_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    IMAGE_PULL_SECRET_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID to deploy the model under"""
    build_id: builtins.str
    """Build ID (which must be successful) to deploy"""
    docker_image: builtins.str
    """Docker image of the model"""
    number_of_pods: builtins.int
    """Number of pods to deploy
    (Deprecated. moved to deployment_size, and if set in deployment_size, it will override that field)
    """
    @property
    def deployment_size(self) -> qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentSize:
        """Deployment size"""
    @property
    def advanced_deployment_options(self) -> qwak.kube_deployment_captain.deployment_pb2.KubeAdvancedDeploymentOptions:
        """Advanced Deployment Options"""
    deployment_id: builtins.str
    """Deployment Id"""
    @property
    def serving_strategy(self) -> qwak.kube_deployment_captain.deployment_pb2.KubeServingStrategy:
        """The type of kube deployment"""
    @property
    def environment_variables(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Environment variables to apply on deployment"""
    @property
    def auto_scaling_spec(self) -> qwak.kube_deployment_captain.deployment_pb2.AutoScalingSpec:
        """Auto scaling specification"""
    model_uuid: builtins.str
    project_id: builtins.str
    """For labels"""
    image_pull_secret: builtins.str
    """Secret to pull image if needed"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        build_id: builtins.str = ...,
        docker_image: builtins.str = ...,
        number_of_pods: builtins.int = ...,
        deployment_size: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentSize | None = ...,
        advanced_deployment_options: qwak.kube_deployment_captain.deployment_pb2.KubeAdvancedDeploymentOptions | None = ...,
        deployment_id: builtins.str = ...,
        serving_strategy: qwak.kube_deployment_captain.deployment_pb2.KubeServingStrategy | None = ...,
        environment_variables: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        auto_scaling_spec: qwak.kube_deployment_captain.deployment_pb2.AutoScalingSpec | None = ...,
        model_uuid: builtins.str = ...,
        project_id: builtins.str = ...,
        image_pull_secret: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["advanced_deployment_options", b"advanced_deployment_options", "auto_scaling_spec", b"auto_scaling_spec", "deployment_size", b"deployment_size", "serving_strategy", b"serving_strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["advanced_deployment_options", b"advanced_deployment_options", "auto_scaling_spec", b"auto_scaling_spec", "branch_id", b"branch_id", "build_id", b"build_id", "deployment_id", b"deployment_id", "deployment_size", b"deployment_size", "docker_image", b"docker_image", "environment_variables", b"environment_variables", "image_pull_secret", b"image_pull_secret", "model_id", b"model_id", "model_uuid", b"model_uuid", "number_of_pods", b"number_of_pods", "project_id", b"project_id", "serving_strategy", b"serving_strategy"]) -> None: ...

global___KubeDeployModelRequest = KubeDeployModelRequest

class KubeDeployModelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___KubeDeployModelResponse = KubeDeployModelResponse

class RevertFailedKubeDeploymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID which the model was deployed under"""
    build_id: builtins.str
    """Build ID"""
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to revert"""
    variation_name: builtins.str
    """Variation name to revert"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        build_id: builtins.str = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        variation_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "build_id", b"build_id", "kube_deployment_type", b"kube_deployment_type", "model_id", b"model_id", "variation_name", b"variation_name"]) -> None: ...

global___RevertFailedKubeDeploymentRequest = RevertFailedKubeDeploymentRequest

class RevertFailedKubeDeploymentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RevertFailedKubeDeploymentResponse = RevertFailedKubeDeploymentResponse

class UpdateKubeDeploymentRuntimeSettingsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SETTINGS_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID which the model was deployed under"""
    @property
    def deployment_settings(self) -> qwak.kube_deployment_captain.deployment_pb2.KubeRuntimeDeploymentSettings: ...
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to update"""
    variation_name: builtins.str
    """Variation name to change settings in."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        deployment_settings: qwak.kube_deployment_captain.deployment_pb2.KubeRuntimeDeploymentSettings | None = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        variation_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_settings", b"deployment_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "deployment_settings", b"deployment_settings", "kube_deployment_type", b"kube_deployment_type", "model_id", b"model_id", "variation_name", b"variation_name"]) -> None: ...

global___UpdateKubeDeploymentRuntimeSettingsRequest = UpdateKubeDeploymentRuntimeSettingsRequest

class UpdateKubeDeploymentRuntimeSettingsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateKubeDeploymentRuntimeSettingsResponse = UpdateKubeDeploymentRuntimeSettingsResponse

class KubeUndeployModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    SELECTED_VARIATION_MAPPING_NAME_FIELD_NUMBER: builtins.int
    LAST_UNDEPLOY_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID"""
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to update"""
    selected_variation_mapping_name: builtins.str
    """Variation name to undeploy"""
    last_undeploy: builtins.bool
    """is last undeploy for model."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        selected_variation_mapping_name: builtins.str = ...,
        last_undeploy: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["kube_deployment_type", b"kube_deployment_type", "last_undeploy", b"last_undeploy", "model_id", b"model_id", "selected_variation_mapping_name", b"selected_variation_mapping_name"]) -> None: ...

global___KubeUndeployModelRequest = KubeUndeployModelRequest

class KubeUndeployModelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___KubeUndeployModelResponse = KubeUndeployModelResponse

class GetKubeModelDeploymentStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID"""
    deployment_id: builtins.str
    """Deployment id"""
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to get status"""
    variation_name: builtins.str
    """Variation name to get status for"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        deployment_id: builtins.str = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        variation_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_id", b"deployment_id", "kube_deployment_type", b"kube_deployment_type", "model_id", b"model_id", "variation_name", b"variation_name"]) -> None: ...

global___GetKubeModelDeploymentStatusRequest = GetKubeModelDeploymentStatusRequest

class GetKubeModelDeploymentStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    FAILURE_REASON_CODE_FIELD_NUMBER: builtins.int
    TECHNICAL_DETAILS_FIELD_NUMBER: builtins.int
    status: global___KubeModelDeploymentStatus.ValueType
    """The status of the deployment"""
    failure_reason_code: builtins.str
    """failure reason"""
    technical_details: builtins.str
    """failure message from kubernetes"""
    def __init__(
        self,
        *,
        status: global___KubeModelDeploymentStatus.ValueType = ...,
        failure_reason_code: builtins.str = ...,
        technical_details: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["failure_reason_code", b"failure_reason_code", "status", b"status", "technical_details", b"technical_details"]) -> None: ...

global___GetKubeModelDeploymentStatusResponse = GetKubeModelDeploymentStatusResponse

class ApplyNotificationsChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_CHANNEL_FIELD_NUMBER: builtins.int
    @property
    def notification_channel(self) -> qwak.kube_deployment_captain.alert_pb2.KubeNotificationChannel:
        """The notifications channels to apply"""
    def __init__(
        self,
        *,
        notification_channel: qwak.kube_deployment_captain.alert_pb2.KubeNotificationChannel | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["notification_channel", b"notification_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification_channel", b"notification_channel"]) -> None: ...

global___ApplyNotificationsChannelRequest = ApplyNotificationsChannelRequest

class ApplyNotificationChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ApplyNotificationChannelResponse = ApplyNotificationChannelResponse

class DeleteNotificationChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_CHANNEL_ID_FIELD_NUMBER: builtins.int
    notification_channel_id: builtins.str
    """The notification channel Id to delete"""
    def __init__(
        self,
        *,
        notification_channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification_channel_id", b"notification_channel_id"]) -> None: ...

global___DeleteNotificationChannelRequest = DeleteNotificationChannelRequest

class DeleteNotificationChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteNotificationChannelResponse = DeleteNotificationChannelResponse

class DeployFeatureSetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_SPEC_FIELD_NUMBER: builtins.int
    @property
    def feature_set_spec(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeploymentSpec:
        """Feature set spec for deployment feature set"""
    def __init__(
        self,
        *,
        feature_set_spec: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeploymentSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_spec", b"feature_set_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["feature_set_spec", b"feature_set_spec"]) -> None: ...

global___DeployFeatureSetRequest = DeployFeatureSetRequest

class DeployFeatureSetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployFeatureSetResponse = DeployFeatureSetResponse

class DeployStreamingAggregationBackfillRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment: ...
    environment_id: builtins.str
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeployStreamingAggregationBackfillRequest = DeployStreamingAggregationBackfillRequest

class BatchFeatureSetV1DeploymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    BATCH_DETAILS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    EXECUTION_IDENTIFIER_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    @property
    def batch_details(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.BatchDetails:
        """Batch details"""
    environment_id: builtins.str
    """Environment id"""
    @property
    def execution_identifier(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.ExecutionIdentifier: ...
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        batch_details: qwak.kube_deployment_captain.feature_set_deployment_pb2.BatchDetails | None = ...,
        environment_id: builtins.str = ...,
        execution_identifier: qwak.kube_deployment_captain.feature_set_deployment_pb2.ExecutionIdentifier | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_details", b"batch_details", "exec_id", b"exec_id", "execution_identifier", b"execution_identifier", "feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_details", b"batch_details", "environment_id", b"environment_id", "exec_id", b"exec_id", "execution_identifier", b"execution_identifier", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["exec_id", b"exec_id"]) -> typing_extensions.Literal["execution_identifier"] | None: ...

global___BatchFeatureSetV1DeploymentRequest = BatchFeatureSetV1DeploymentRequest

class DeployBatchBackfillRequest(google.protobuf.message.Message):
    """Deploy BatchV1 backfill"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    BACKFILL_SPEC_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    EXECUTION_IDENTIFIER_FIELD_NUMBER: builtins.int
    LAST_KNOWN_BATCH_EXECUTION_DATE_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    @property
    def backfill_spec(self) -> qwak.execution.v1.backfill_pb2.BackfillSpec:
        """Backfill spec"""
    environment_id: builtins.str
    """Environment id"""
    @property
    def execution_identifier(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.ExecutionIdentifier:
        """Execution Identifier"""
    @property
    def last_known_batch_execution_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Latest Batch Eecution Date known to have succeeded"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        backfill_spec: qwak.execution.v1.backfill_pb2.BackfillSpec | None = ...,
        environment_id: builtins.str = ...,
        execution_identifier: qwak.kube_deployment_captain.feature_set_deployment_pb2.ExecutionIdentifier | None = ...,
        last_known_batch_execution_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["backfill_spec", b"backfill_spec", "execution_identifier", b"execution_identifier", "feature_set_deployment", b"feature_set_deployment", "last_known_batch_execution_date", b"last_known_batch_execution_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["backfill_spec", b"backfill_spec", "environment_id", b"environment_id", "execution_identifier", b"execution_identifier", "feature_set_deployment", b"feature_set_deployment", "last_known_batch_execution_date", b"last_known_batch_execution_date"]) -> None: ...

global___DeployBatchBackfillRequest = DeployBatchBackfillRequest

class DeployBatchBackfillResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployBatchBackfillResponse = DeployBatchBackfillResponse

class UndeployBatchBackfillRequest(google.protobuf.message.Message):
    """undeploy BatchV1 backfill, if exists"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURESET_NAME_FIELD_NUMBER: builtins.int
    featureset_name: builtins.str
    def __init__(
        self,
        *,
        featureset_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["featureset_name", b"featureset_name"]) -> None: ...

global___UndeployBatchBackfillRequest = UndeployBatchBackfillRequest

class UndeployBatchBackfillResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployBatchBackfillResponse = UndeployBatchBackfillResponse

class DeleteBatchFeatureSetV1Request(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    environment_id: builtins.str
    """Environment id"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeleteBatchFeatureSetV1Request = DeleteBatchFeatureSetV1Request

class DeleteBatchFeatureSetV1Response(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteBatchFeatureSetV1Response = DeleteBatchFeatureSetV1Response

class DeleteStreamingFeatureSetV1Request(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    environment_id: builtins.str
    """Environment id"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeleteStreamingFeatureSetV1Request = DeleteStreamingFeatureSetV1Request

class DeleteStreamingFeatureSetV1Response(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteStreamingFeatureSetV1Response = DeleteStreamingFeatureSetV1Response

class DeleteStreamingAggregationFeatureSetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    environment_id: builtins.str
    """Environment id"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeleteStreamingAggregationFeatureSetRequest = DeleteStreamingAggregationFeatureSetRequest

class DeleteStreamingAggregationFeatureSetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteStreamingAggregationFeatureSetResponse = DeleteStreamingAggregationFeatureSetResponse

class DeployStreamingAggregationCompactionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    environment_id: builtins.str
    """Environment id"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeployStreamingAggregationCompactionRequest = DeployStreamingAggregationCompactionRequest

class DeployStreamingAggregationRowLevelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___DeployStreamingAggregationRowLevelRequest = DeployStreamingAggregationRowLevelRequest

class StreamingFeatureSetV1DeploymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_DEPLOYMENT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def feature_set_deployment(self) -> qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment:
        """Featureset deployment properties"""
    environment_id: builtins.str
    """Environment id"""
    def __init__(
        self,
        *,
        feature_set_deployment: qwak.kube_deployment_captain.feature_set_deployment_pb2.FeatureSetDeployment | None = ...,
        environment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["feature_set_deployment", b"feature_set_deployment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "feature_set_deployment", b"feature_set_deployment"]) -> None: ...

global___StreamingFeatureSetV1DeploymentRequest = StreamingFeatureSetV1DeploymentRequest

class DeployStreamingAggregationBackfillResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployStreamingAggregationBackfillResponse = DeployStreamingAggregationBackfillResponse

class DeployStreamingAggregationRowLevelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployStreamingAggregationRowLevelResponse = DeployStreamingAggregationRowLevelResponse

class DeployStreamingAggregationCompactionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeployStreamingAggregationCompactionResponse = DeployStreamingAggregationCompactionResponse

class UndeployFeatureSetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURE_SET_NAME_FIELD_NUMBER: builtins.int
    feature_set_name: builtins.str
    """Feature set name for undeploy"""
    def __init__(
        self,
        *,
        feature_set_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["feature_set_name", b"feature_set_name"]) -> None: ...

global___UndeployFeatureSetRequest = UndeployFeatureSetRequest

class UndeployFeatureSetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployFeatureSetResponse = UndeployFeatureSetResponse

class UndeployBatchFeaturesetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURESET_NAME_FIELD_NUMBER: builtins.int
    featureset_name: builtins.str
    """Batch featureset name for undeploy"""
    def __init__(
        self,
        *,
        featureset_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["featureset_name", b"featureset_name"]) -> None: ...

global___UndeployBatchFeaturesetRequest = UndeployBatchFeaturesetRequest

class UndeployBatchFeaturesetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeployBatchFeaturesetResponse = UndeployBatchFeaturesetResponse

class ApplyModelTrafficMappingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    VARIATION_MAPPINGS_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model id to apply new traffic on."""
    @property
    def variation_mappings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.kube_deployment_captain.traffic_mapping_pb2.VariationMapping]:
        """All models variations mappings"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        variation_mappings: collections.abc.Iterable[qwak.kube_deployment_captain.traffic_mapping_pb2.VariationMapping] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id", "variation_mappings", b"variation_mappings"]) -> None: ...

global___ApplyModelTrafficMappingRequest = ApplyModelTrafficMappingRequest

class ApplyModelTrafficMappingResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ApplyModelTrafficMappingResponse = ApplyModelTrafficMappingResponse

class RevertModelDeploymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    variation_name: builtins.str
    """Variation name to revert"""
    kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType
    """Deployment type to revert"""
    deployment_id: builtins.str
    """The deployment id - to revert."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        variation_name: builtins.str = ...,
        kube_deployment_type: qwak.kube_deployment_captain.deployment_pb2.KubeDeploymentType.ValueType = ...,
        deployment_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_id", b"deployment_id", "kube_deployment_type", b"kube_deployment_type", "model_id", b"model_id", "variation_name", b"variation_name"]) -> None: ...

global___RevertModelDeploymentRequest = RevertModelDeploymentRequest

class RevertModelDeploymentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RevertModelDeploymentResponse = RevertModelDeploymentResponse
